/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.misc;

import com.jetbrains.pluginverifier.misc.ExponentialBackOff;
import com.jetbrains.pluginverifier.misc.RecoverStrategy;
import com.jetbrains.pluginverifier.misc.Retry;
import com.jetbrains.pluginverifier.misc.Sleep;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aF\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0005*\u0002H\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00050\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010\u000e\u001aF\u0010\u000f\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0005*\u0002H\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00050\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"INITIAL_DELAY_MS", "", "LOG", "Lorg/slf4j/Logger;", "poll", "R", "T", "presentableBlockName", "", "maxAttempts", "", "operation", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Ljava/lang/String;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "retry", "recover", "Lcom/jetbrains/pluginverifier/misc/RecoverStrategy;", "body", "(Ljava/lang/Object;Ljava/lang/String;Lcom/jetbrains/pluginverifier/misc/RecoverStrategy;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "verifier-repository"})
public final class RetryUtilKt {
    @NotNull
    private static final Logger LOG;
    private static final long INITIAL_DELAY_MS;

    public static final <T, R> R retry(T $this$retry, @NotNull String presentableBlockName, @NotNull RecoverStrategy recover, @NotNull Function1<? super T, ? extends R> body) {
        Intrinsics.checkNotNullParameter(presentableBlockName, "presentableBlockName");
        Intrinsics.checkNotNullParameter(recover, "recover");
        Intrinsics.checkNotNullParameter(body, "body");
        return new Retry<T>(presentableBlockName, 5, recover, $this$retry).retry(body);
    }

    public static /* synthetic */ Object retry$default(Object object, String string, RecoverStrategy recoverStrategy, Function1 function1, int n, Object object2) {
        if ((n & 2) != 0) {
            recoverStrategy = new ExponentialBackOff(0L, 1, null);
        }
        return RetryUtilKt.retry(object, string, recoverStrategy, function1);
    }

    public static final <T, R> R poll(T $this$poll, @NotNull String presentableBlockName, int maxAttempts, @NotNull Function1<? super T, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(presentableBlockName, "presentableBlockName");
        Intrinsics.checkNotNullParameter(operation, "operation");
        return new Retry<T>(presentableBlockName, maxAttempts, Sleep.Companion.getTHIRTY_SECONDS(), $this$poll).retry(operation);
    }

    public static /* synthetic */ Object poll$default(Object object, String string, int n, Function1 function1, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        return RetryUtilKt.poll(object, string, n, function1);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ long access$getINITIAL_DELAY_MS$p() {
        return INITIAL_DELAY_MS;
    }

    static {
        Logger logger = LoggerFactory.getLogger(Retry.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(Retry::class.java)");
        LOG = logger;
        INITIAL_DELAY_MS = TimeUnit.SECONDS.toMillis(10L);
    }
}

