/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.verifiers;

import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.problems.ForbiddenPluginIdPrefix;
import com.jetbrains.plugin.structure.intellij.problems.PropertyWithDefaultValue;
import com.jetbrains.plugin.structure.intellij.problems.TemplateWordInPluginId;
import com.jetbrains.plugin.structure.intellij.verifiers.PluginIdVerifierKt;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import com.jetbrains.plugin.structure.intellij.verifiers.SimpleVerifiersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginIdVerifier;", "", "()V", "verify", "", "plugin", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "descriptorPath", "", "problemRegistrar", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "verifyPrefix", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginIdVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginIdVerifier.kt\ncom/jetbrains/plugin/structure/intellij/verifiers/PluginIdVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n766#2:49\n857#2,2:50\n1855#2,2:52\n766#2:54\n857#2,2:55\n1855#2,2:57\n*E\n*S KotlinDebug\n*F\n+ 1 PluginIdVerifier.kt\ncom/jetbrains/plugin/structure/intellij/verifiers/PluginIdVerifier\n*L\n40#1:49\n40#1,2:50\n41#1,2:52\n44#1:54\n44#1,2:55\n45#1,2:57\n*E\n"})
public final class PluginIdVerifier {
    public final void verify(@NotNull PluginBean plugin, @NotNull String descriptorPath, @NotNull ProblemRegistrar problemRegistrar2) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(problemRegistrar2, "problemRegistrar");
        String string = plugin.id;
        if (string == null) {
            return;
        }
        String id = string;
        if (StringsKt.isBlank(id)) {
            problemRegistrar2.registerProblem(new PropertyNotSpecified("id", null, 2, null));
        } else if (Intrinsics.areEqual("com.your.company.unique.plugin.id", id)) {
            problemRegistrar2.registerProblem(new PropertyWithDefaultValue(descriptorPath, PropertyWithDefaultValue.DefaultProperty.ID, id));
        } else {
            SimpleVerifiersKt.verifyPropertyLength("id", id, 255, descriptorPath, problemRegistrar2);
            SimpleVerifiersKt.verifyNewlines("id", id, descriptorPath, problemRegistrar2);
            this.verifyPrefix(plugin, descriptorPath, problemRegistrar2);
        }
    }

    private final void verifyPrefix(PluginBean plugin, String descriptorPath, ProblemRegistrar problemRegistrar2) {
        Object $this$forEach$iv;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String id = plugin.id;
        Iterable iterable = PluginIdVerifierKt.getDEFAULT_ILLEGAL_PREFIXES();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            element$iv$iv = iterator3.next();
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(id, "id::startsWith");
            if (!StringsKt.startsWith$default(id, p0, false, 2, null)) continue;
            collection.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection;
        boolean $i$f$forEach = false;
        for (Object t2 : $this$forEach$iv) {
            String it = (String)t2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(id, "id");
            problemRegistrar2.registerProblem(new ForbiddenPluginIdPrefix(descriptorPath, id, it));
        }
        Intrinsics.checkNotNullExpressionValue(id, "id");
        $this$forEach$iv = new char[]{'.'};
        $this$forEach$iv = StringsKt.split$default((CharSequence)id, $this$forEach$iv, false, 0, 6, null);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        Collection collection2 = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            String idComponent = (String)element$iv$iv;
            boolean bl2 = false;
            List<String> list = PluginIdVerifierKt.getPRODUCT_ID_RESTRICTED_WORDS();
            String string = idComponent.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            if (!list.contains(string)) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        $i$f$forEach = false;
        for (Object t3 : $this$forEach$iv) {
            String idComponent = (String)t3;
            boolean bl3 = false;
            problemRegistrar2.registerProblem(new TemplateWordInPluginId(descriptorPath, id, idComponent));
        }
    }
}

