/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000e\u001a\n\u0010 \u001a\u00020!*\u00020\r\u001a\n\u0010\"\u001a\u00020\r*\u00020\r\u001a\n\u0010#\u001a\u00020\r*\u00020\r\u001a\n\u0010$\u001a\u00020%*\u00020\r\u001a\n\u0010&\u001a\u00020\u0013*\u00020\r\u001a\n\u0010'\u001a\u00020\u0013*\u00020\r\u001a\n\u0010(\u001a\u00020\u0013*\u00020\r\u001a7\u0010)\u001a\u00020%*\u00020\r2\b\b\u0002\u0010*\u001a\u00020+2!\u0010,\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020%0-\u001a\n\u00101\u001a\u00020%*\u00020\r\u001a\n\u00102\u001a\u00020%*\u00020\r\u001a\u0012\u00103\u001a\u00020\u0013*\u00020\r2\u0006\u00104\u001a\u00020\f\u001a\n\u00105\u001a\u000206*\u00020\r\u001a\n\u00107\u001a\u00020\u0013*\u00020\r\u001a\n\u00108\u001a\u00020\u0013*\u00020\r\u001a\u0018\u00109\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\r0\r0:*\u00020\r\u001a\u0010\u0010;\u001a\b\u0012\u0004\u0012\u00020\r0:*\u00020\r\u001a\u0010\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0:*\u00020\r\u001a \u0010=\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\r0\r0:*\u00020\r2\u0006\u0010\u0010\u001a\u00020\f\u001a\n\u0010>\u001a\u00020?*\u00020\r\u001a\n\u0010@\u001a\u00020A*\u00020\r\u001a\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020\f0:*\u00020\r2\b\b\u0002\u0010*\u001a\u00020+\u001a\u0014\u0010C\u001a\u00020\f*\u00020\r2\b\b\u0002\u0010*\u001a\u00020+\u001a\n\u0010D\u001a\u00020\f*\u00020\f\u001a\n\u0010E\u001a\u00020\f*\u00020\f\u001a\n\u0010F\u001a\u00020\f*\u00020\f\u001a\u0012\u0010G\u001a\u00020\f*\u00020\f2\u0006\u0010H\u001a\u00020\r\u001a\n\u0010I\u001a\u00020\f*\u00020\f\u001a\u0012\u0010J\u001a\u00020%*\u00020\r2\u0006\u0010K\u001a\u00020A\u001a\u001c\u0010L\u001a\u00020%*\u00020\r2\u0006\u0010M\u001a\u00020\f2\b\b\u0002\u0010*\u001a\u00020+\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\"\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0013*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014\"\u0015\u0010\u0016\u001a\u00020\u0001*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000f\"\u0019\u0010\u001b\u001a\u00060\u0001j\u0002`\u001c*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018\"\u0015\u0010\u001e\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000f*\n\u0010N\"\u00020\u00012\u00020\u0001\u00a8\u0006O"}, d2={"FIVE_GB", "", "getFIVE_GB", "()J", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ONE_GB_BD", "Ljava/math/BigDecimal;", "getONE_GB_BD", "()Ljava/math/BigDecimal;", "description", "", "Ljava/nio/file/Path;", "getDescription", "(Ljava/nio/file/Path;)Ljava/lang/String;", "extension", "getExtension", "isDirectory", "", "(Ljava/nio/file/Path;)Z", "isFile", "length", "getLength", "(Ljava/nio/file/Path;)J", "nameWithoutExtension", "getNameWithoutExtension", "pluginSize", "Lcom/jetbrains/plugin/structure/base/utils/Bytes;", "getPluginSize", "simpleName", "getSimpleName", "bufferedInputStream", "Ljava/io/BufferedInputStream;", "create", "createDir", "createParentDirs", "", "deleteLogged", "deleteQuietly", "exists", "forEachLine", "charset", "Ljava/nio/charset/Charset;", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "line", "forceDeleteIfExists", "forceRemoveDirectory", "hasExtension", "expected", "inputStream", "Ljava/io/InputStream;", "isJar", "isZip", "listAllFiles", "", "listFiles", "listJars", "listRecursivelyAllFilesWithExtension", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readLines", "readText", "replaceInvalidFileNameCharacters", "toSystemDependentName", "toSystemIndependentName", "withPathSeparatorOf", "path", "withZipFsSeparator", "writeBytes", "bytes", "writeText", "text", "Bytes", "structure-base"})
@SourceDebugExtension(value={"SMAP\nFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtil.kt\ncom/jetbrains/plugin/structure/base/utils/FileUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1#2:192\n766#3:193\n857#3,2:194\n*E\n*S KotlinDebug\n*F\n+ 1 FileUtil.kt\ncom/jetbrains/plugin/structure/base/utils/FileUtilKt\n*L\n128#1:193\n128#1,2:194\n*E\n"})
public final class FileUtilKt {
    private static final Logger LOG = LoggerFactory.getLogger("structure.FileUtil");
    @NotNull
    private static final BigDecimal ONE_GB_BD = new BigDecimal(0x40000000L);
    private static final long FIVE_GB = new BigDecimal("5").multiply(ONE_GB_BD).longValue();

    @NotNull
    public static final BigDecimal getONE_GB_BD() {
        return ONE_GB_BD;
    }

    public static final long getFIVE_GB() {
        return FIVE_GB;
    }

    public static final boolean isZip(@NotNull Path $this$isZip) {
        Intrinsics.checkNotNullParameter($this$isZip, "<this>");
        return FileUtilKt.hasExtension($this$isZip, "zip");
    }

    public static final boolean isJar(@NotNull Path $this$isJar) {
        Intrinsics.checkNotNullParameter($this$isJar, "<this>");
        return FileUtilKt.hasExtension($this$isJar, "jar");
    }

    public static final boolean hasExtension(@NotNull Path $this$hasExtension, @NotNull String expected) {
        Intrinsics.checkNotNullParameter($this$hasExtension, "<this>");
        Intrinsics.checkNotNullParameter(expected, "expected");
        return Files.isRegularFile($this$hasExtension, new LinkOption[0]) && Intrinsics.areEqual(expected, FileUtilKt.getExtension($this$hasExtension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> listRecursivelyAllFilesWithExtension(@NotNull Path $this$listRecursivelyAllFilesWithExtension, @NotNull String extension) {
        List<Path> list;
        Intrinsics.checkNotNullParameter($this$listRecursivelyAllFilesWithExtension, "<this>");
        Intrinsics.checkNotNullParameter(extension, "extension");
        Object object = new FileVisitOption[]{FileVisitOption.FOLLOW_LINKS};
        object = Files.walk($this$listRecursivelyAllFilesWithExtension, object);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)object;
            boolean bl = false;
            Function1 function1 = new Function1<Path, Boolean>(extension){
                final /* synthetic */ String $extension;
                {
                    this.$extension = $extension;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Path it) {
                    return StringsKt.endsWith$default(((Object)it).toString(), "." + this.$extension, false, 2, null);
                }
            };
            Stream stream2 = stream.filter(new Predicate(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter(function, "function");
                    this.function = function;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue(stream2, "extension: String) =\n  F\u2026dsWith(\".${extension}\") }");
            list = StreamsKt.toList(stream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
        }
        return list;
    }

    @NotNull
    public static final String withPathSeparatorOf(@NotNull String $this$withPathSeparatorOf, @NotNull Path path) {
        Intrinsics.checkNotNullParameter($this$withPathSeparatorOf, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        String string = StringsKt.replace$default($this$withPathSeparatorOf, '\\', '/', false, 4, null);
        String string2 = path.getFileSystem().getSeparator();
        Intrinsics.checkNotNullExpressionValue(string2, "path.fileSystem.separator");
        return StringsKt.replace$default(string, "/", string2, false, 4, null);
    }

    @NotNull
    public static final String withZipFsSeparator(@NotNull String $this$withZipFsSeparator) {
        Intrinsics.checkNotNullParameter($this$withZipFsSeparator, "<this>");
        return StringsKt.replace$default($this$withZipFsSeparator, '\\', '/', false, 4, null);
    }

    @NotNull
    public static final String toSystemIndependentName(@NotNull String $this$toSystemIndependentName) {
        Intrinsics.checkNotNullParameter($this$toSystemIndependentName, "<this>");
        return StringsKt.replace$default($this$toSystemIndependentName, '\\', '/', false, 4, null);
    }

    @NotNull
    public static final String toSystemDependentName(@NotNull String $this$toSystemDependentName) {
        Intrinsics.checkNotNullParameter($this$toSystemDependentName, "<this>");
        String string = FileSystems.getDefault().getSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "getDefault().separator");
        return StringsKt.replace$default($this$toSystemDependentName, "/", string, false, 4, null);
    }

    @NotNull
    public static final String replaceInvalidFileNameCharacters(@NotNull String $this$replaceInvalidFileNameCharacters) {
        Intrinsics.checkNotNullParameter($this$replaceInvalidFileNameCharacters, "<this>");
        CharSequence charSequence = $this$replaceInvalidFileNameCharacters;
        Regex regex = new Regex("[^a-zA-Z0-9.#\\-() ]");
        String string = "_";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final InputStream inputStream(@NotNull Path $this$inputStream) {
        Intrinsics.checkNotNullParameter($this$inputStream, "<this>");
        InputStream inputStream2 = Files.newInputStream($this$inputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(this)");
        return inputStream2;
    }

    @NotNull
    public static final BufferedInputStream bufferedInputStream(@NotNull Path $this$bufferedInputStream) {
        Intrinsics.checkNotNullParameter($this$bufferedInputStream, "<this>");
        InputStream inputStream2 = Files.newInputStream($this$bufferedInputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(this)");
        InputStream inputStream3 = inputStream2;
        int n = 8192;
        return inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n);
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream) {
        Intrinsics.checkNotNullParameter($this$outputStream, "<this>");
        OutputStream outputStream2 = Files.newOutputStream($this$outputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(outputStream2, "newOutputStream(this)");
        return outputStream2;
    }

    public static final void writeText(@NotNull Path $this$writeText, @NotNull String text, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$writeText, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        byte[] byArray = text.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        FileUtilKt.writeBytes($this$writeText, byArray);
    }

    public static /* synthetic */ void writeText$default(Path path, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FileUtilKt.writeText(path, string, charset);
    }

    @NotNull
    public static final String readText(@NotNull Path $this$readText, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$readText, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        byte[] byArray = Files.readAllBytes($this$readText);
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(this)");
        byte[] byArray2 = byArray;
        return new String(byArray2, charset);
    }

    public static /* synthetic */ String readText$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileUtilKt.readText(path, charset);
    }

    @NotNull
    public static final List<String> readLines(@NotNull Path $this$readLines, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$readLines, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        ArrayList<String> result2 = new ArrayList<String>();
        FileUtilKt.forEachLine($this$readLines, charset, (Function1<? super String, Unit>)new Function1<String, Unit>(result2){
            final /* synthetic */ ArrayList<String> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$result.add(it);
            }
        });
        return result2;
    }

    public static /* synthetic */ List readLines$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileUtilKt.readLines(path, charset);
    }

    public static final void forEachLine(@NotNull Path $this$forEachLine, @NotNull Charset charset, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forEachLine, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(action, "action");
        TextStreamsKt.forEachLine(new BufferedReader(new InputStreamReader(Files.newInputStream($this$forEachLine, new OpenOption[0]), charset)), action);
    }

    public static /* synthetic */ void forEachLine$default(Path path, Charset charset, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        FileUtilKt.forEachLine(path, charset, function1);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Path $this$readBytes) {
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        byte[] byArray = Files.readAllBytes($this$readBytes);
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(this)");
        return byArray;
    }

    public static final void writeBytes(@NotNull Path $this$writeBytes, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter($this$writeBytes, "<this>");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Files.write($this$writeBytes, bytes, new OpenOption[0]);
    }

    @NotNull
    public static final Path createDir(@NotNull Path $this$createDir) {
        Intrinsics.checkNotNullParameter($this$createDir, "<this>");
        Files.createDirectories($this$createDir, new FileAttribute[0]);
        return $this$createDir;
    }

    @NotNull
    public static final Path create(@NotNull Path $this$create) {
        Intrinsics.checkNotNullParameter($this$create, "<this>");
        if ($this$create.getParent() != null) {
            Files.createDirectories($this$create.getParent(), new FileAttribute[0]);
        }
        Files.createFile($this$create, new FileAttribute[0]);
        return $this$create;
    }

    public static final void createParentDirs(@NotNull Path $this$createParentDirs) {
        block0: {
            Intrinsics.checkNotNullParameter($this$createParentDirs, "<this>");
            Path path = $this$createParentDirs.getParent();
            if (path == null) break block0;
            FileUtilKt.createDir(path);
        }
    }

    public static final void forceDeleteIfExists(@NotNull Path $this$forceDeleteIfExists) {
        Intrinsics.checkNotNullParameter($this$forceDeleteIfExists, "<this>");
        if (Files.exists($this$forceDeleteIfExists, new LinkOption[0])) {
            if (Files.isDirectory($this$forceDeleteIfExists, new LinkOption[0])) {
                FileUtilKt.forceRemoveDirectory($this$forceDeleteIfExists);
            } else {
                Files.delete($this$forceDeleteIfExists);
            }
        }
    }

    public static final boolean deleteLogged(@NotNull Path $this$deleteLogged) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$deleteLogged, "<this>");
        try {
            FileUtilKt.forceDeleteIfExists($this$deleteLogged);
            bl = true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.info("Cannot delete file because of interruption:  " + $this$deleteLogged);
            bl = false;
        }
        catch (Exception e) {
            LOG.error("Unable to delete " + $this$deleteLogged, e);
            bl = false;
        }
        return bl;
    }

    public static final boolean exists(@NotNull Path $this$exists) {
        Intrinsics.checkNotNullParameter($this$exists, "<this>");
        return Files.exists($this$exists, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> listFiles(@NotNull Path $this$listFiles) {
        List<Path> list;
        Intrinsics.checkNotNullParameter($this$listFiles, "<this>");
        if (!FileUtilKt.isDirectory($this$listFiles)) {
            return CollectionsKt.emptyList();
        }
        AutoCloseable autoCloseable = Files.list($this$listFiles);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            List<Path> list2 = it.collect(Collectors.toList());
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, "list(this).use { it.collect(Collectors.toList()) }");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> listJars(@NotNull Path $this$listJars) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$listJars, "<this>");
        Iterable $this$filter$iv = FileUtilKt.listFiles($this$listJars);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!FileUtilKt.isJar(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> listAllFiles(@NotNull Path $this$listAllFiles) {
        List<Path> list;
        Intrinsics.checkNotNullParameter($this$listAllFiles, "<this>");
        AutoCloseable autoCloseable = Files.walk($this$listAllFiles, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Function1 function1 = listAllFiles.1.1.INSTANCE;
            Predicate predicate2 = new /* invalid duplicate definition of identical inner class */;
            function1 = new Function1<Path, Path>($this$listAllFiles){
                final /* synthetic */ Path $this_listAllFiles;
                {
                    this.$this_listAllFiles = $receiver;
                    super(1);
                }

                public final Path invoke(Path it) {
                    return this.$this_listAllFiles.relativize(it);
                }
            };
            Stream stream2 = stream.filter(predicate2).map(new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter(function, "function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue(stream2, "Path.listAllFiles() =\n  \u2026p { this.relativize(it) }");
            list = StreamsKt.toList(stream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return list;
    }

    public static final boolean deleteQuietly(@NotNull Path $this$deleteQuietly) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$deleteQuietly, "<this>");
        try {
            if (FileUtilKt.isDirectory($this$deleteQuietly)) {
                FileUtilKt.forceRemoveDirectory($this$deleteQuietly);
            } else {
                Files.delete($this$deleteQuietly);
            }
            bl = true;
        }
        catch (Exception ignored) {
            bl = false;
        }
        return bl;
    }

    public static final void forceRemoveDirectory(@NotNull Path $this$forceRemoveDirectory) {
        Intrinsics.checkNotNullParameter($this$forceRemoveDirectory, "<this>");
        Files.walkFileTree($this$forceRemoveDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                Intrinsics.checkNotNullParameter(file, "file");
                Intrinsics.checkNotNullParameter(attrs, "attrs");
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir2, @Nullable IOException exc) throws IOException {
                Intrinsics.checkNotNullParameter(dir2, "dir");
                Files.delete(dir2);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkNotNullParameter($this$isDirectory, "<this>");
        return Files.isDirectory($this$isDirectory, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $this$isFile) {
        Intrinsics.checkNotNullParameter($this$isFile, "<this>");
        return Files.isRegularFile($this$isFile, new LinkOption[0]);
    }

    @NotNull
    public static final String getSimpleName(@NotNull Path $this$simpleName) {
        Intrinsics.checkNotNullParameter($this$simpleName, "<this>");
        Path path = $this$simpleName.getFileName();
        return (path != null ? (Comparable)path : (Comparable)((Object)"")).toString();
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull Path $this$nameWithoutExtension) {
        Intrinsics.checkNotNullParameter($this$nameWithoutExtension, "<this>");
        return StringsKt.substringBeforeLast$default(FileUtilKt.getSimpleName($this$nameWithoutExtension), ".", null, 2, null);
    }

    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        Intrinsics.checkNotNullParameter($this$extension, "<this>");
        return StringsKt.substringAfterLast(FileUtilKt.getSimpleName($this$extension), ".", "");
    }

    public static final long getLength(@NotNull Path $this$length) {
        Intrinsics.checkNotNullParameter($this$length, "<this>");
        return Files.size($this$length);
    }

    public static final long getPluginSize(@NotNull Path $this$pluginSize) {
        Intrinsics.checkNotNullParameter($this$pluginSize, "<this>");
        return FileUtilKt.isZip($this$pluginSize) || FileUtilKt.isJar($this$pluginSize) ? Files.size($this$pluginSize) : -1L;
    }

    @NotNull
    public static final String getDescription(@NotNull Path $this$description) {
        Intrinsics.checkNotNullParameter($this$description, "<this>");
        return Intrinsics.areEqual($this$description.getFileSystem(), FileSystems.getDefault()) ? ((Object)$this$description).toString() : $this$description.getFileSystem() + "!" + $this$description;
    }
}

