/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.problems;

import com.jetbrains.plugin.structure.base.problems.InvalidPluginName;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.TooLongPropertyValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a$\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u001a4\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"ALLOWED_NAME_SYMBOLS", "Lkotlin/text/Regex;", "getALLOWED_NAME_SYMBOLS", "()Lkotlin/text/Regex;", "validatePluginNameIsCorrect", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "descriptor", "", "name", "", "problems", "", "validatePropertyLength", "propertyName", "propertyValue", "maxLength", "", "structure-base"})
public final class ValidatorKt {
    @NotNull
    private static final Regex ALLOWED_NAME_SYMBOLS = new Regex("[a-zA-Z0-9 .,+_\\-/:()#'&\\[\\]|]+");

    @NotNull
    public static final Regex getALLOWED_NAME_SYMBOLS() {
        return ALLOWED_NAME_SYMBOLS;
    }

    public static final void validatePropertyLength(@NotNull String descriptor2, @NotNull String propertyName, @NotNull String propertyValue, int maxLength, @NotNull List<PluginProblem> problems) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Intrinsics.checkNotNullParameter(propertyValue, "propertyValue");
        Intrinsics.checkNotNullParameter(problems, "problems");
        if (propertyValue.length() > maxLength) {
            problems.add(new TooLongPropertyValue(descriptor2, propertyName, propertyValue.length(), maxLength));
        }
    }

    public static final void validatePluginNameIsCorrect(@NotNull String descriptor2, @NotNull String name, @NotNull List<PluginProblem> problems) {
        block0: {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(problems, "problems");
            PluginProblem pluginProblem = ValidatorKt.validatePluginNameIsCorrect(descriptor2, name);
            if (pluginProblem == null) break block0;
            PluginProblem it = pluginProblem;
            boolean bl = false;
            problems.add(it);
        }
    }

    @Nullable
    public static final PluginProblem validatePluginNameIsCorrect(@NotNull String descriptor2, @NotNull String name) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(name, "name");
        CharSequence charSequence = name;
        return !ALLOWED_NAME_SYMBOLS.matches(charSequence) ? (PluginProblem)new InvalidPluginName(descriptor2, name) : null;
    }
}

