/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.plugin;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugin/structure/base/plugin/Settings;", "", "key", "", "defaultValue", "Lkotlin/Function0;", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function0;)V", "get", "getAsInt", "", "getAsLong", "", "getAsPath", "Ljava/nio/file/Path;", "set", "", "value", "EXTRACT_DIRECTORY", "INTELLIJ_PLUGIN_SIZE_LIMIT", "FLEET_PLUGIN_SIZE_LIMIT", "TOOLBOX_PLUGIN_SIZE_LIMIT", "TEAM_CITY_PLUGIN_SIZE_LIMIT", "TEAM_CITY_RECIPE_SIZE_LIMIT", "RE_SHARPER_PLUGIN_SIZE_LIMIT", "HUB_PLUGIN_SIZE_LIMIT", "HUB_PLUGIN_MAX_FILES_NUMBER", "EDU_PLUGIN_SIZE_LIMIT", "YOUTRACK_PLUGIN_SIZE_LIMIT", "KTOR_FEATURE_SIZE_LIMIT", "structure-base"})
public final class Settings
extends Enum<Settings> {
    @NotNull
    private final String key;
    @NotNull
    private final Function0<String> defaultValue;
    public static final /* enum */ Settings EXTRACT_DIRECTORY = new Settings("intellij.structure.temp.dir", 1.INSTANCE);
    public static final /* enum */ Settings INTELLIJ_PLUGIN_SIZE_LIMIT = new Settings("intellij.structure.intellij.plugin.size.limit", 2.INSTANCE);
    public static final /* enum */ Settings FLEET_PLUGIN_SIZE_LIMIT = new Settings("intellij.structure.fleet.plugin.size.limit", 3.INSTANCE);
    public static final /* enum */ Settings TOOLBOX_PLUGIN_SIZE_LIMIT = new Settings("intellij.structure.toolbox.plugin.size.limit", 4.INSTANCE);
    public static final /* enum */ Settings TEAM_CITY_PLUGIN_SIZE_LIMIT = new Settings("intellij.structure.team.city.plugin.size.limit", 5.INSTANCE);
    public static final /* enum */ Settings TEAM_CITY_RECIPE_SIZE_LIMIT = new Settings("intellij.structure.teamcity.recipe.size.limit", 6.INSTANCE);
    public static final /* enum */ Settings RE_SHARPER_PLUGIN_SIZE_LIMIT = new Settings("intellij.structure.re.sharper.plugin.size.limit", 7.INSTANCE);
    public static final /* enum */ Settings HUB_PLUGIN_SIZE_LIMIT = new Settings("intellij.structure.hub.plugin.size.limit", 8.INSTANCE);
    public static final /* enum */ Settings HUB_PLUGIN_MAX_FILES_NUMBER = new Settings("intellij.structure.hub.plugin.max.files.number", 9.INSTANCE);
    public static final /* enum */ Settings EDU_PLUGIN_SIZE_LIMIT = new Settings("intellij.structure.edu.plugin.size.limit", 10.INSTANCE);
    public static final /* enum */ Settings YOUTRACK_PLUGIN_SIZE_LIMIT = new Settings("intellij.structure.youtrack.plugin.size.limit", 11.INSTANCE);
    public static final /* enum */ Settings KTOR_FEATURE_SIZE_LIMIT = new Settings("intellij.structure.edu.plugin.size.limit", 12.INSTANCE);
    private static final /* synthetic */ Settings[] $VALUES;

    private Settings(String key, Function0<String> defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @NotNull
    public final String get() {
        String string = System.getProperty(this.key);
        if (string == null) {
            string = this.defaultValue.invoke();
        }
        return string;
    }

    @NotNull
    public final Path getAsPath() {
        Path path = Paths.get(this.get(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(get())");
        return path;
    }

    public final long getAsLong() {
        return Long.parseLong(this.get());
    }

    public final int getAsInt() {
        return Integer.parseInt(this.get());
    }

    public final void set(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        System.setProperty(this.key, value);
    }

    public static Settings[] values() {
        return (Settings[])$VALUES.clone();
    }

    public static Settings valueOf(String value) {
        return Enum.valueOf(Settings.class, value);
    }

    static {
        $VALUES = settingsArray = new Settings[]{Settings.EXTRACT_DIRECTORY, Settings.INTELLIJ_PLUGIN_SIZE_LIMIT, Settings.FLEET_PLUGIN_SIZE_LIMIT, Settings.TOOLBOX_PLUGIN_SIZE_LIMIT, Settings.TEAM_CITY_PLUGIN_SIZE_LIMIT, Settings.TEAM_CITY_RECIPE_SIZE_LIMIT, Settings.RE_SHARPER_PLUGIN_SIZE_LIMIT, Settings.HUB_PLUGIN_SIZE_LIMIT, Settings.HUB_PLUGIN_MAX_FILES_NUMBER, Settings.EDU_PLUGIN_SIZE_LIMIT, Settings.YOUTRACK_PLUGIN_SIZE_LIMIT, Settings.KTOR_FEATURE_SIZE_LIMIT};
    }
}

