/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.instances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginUpdateManager;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import org.jetbrains.intellij.pluginRepository.model.IntellijUpdateMetadata;
import org.jetbrains.intellij.pluginRepository.model.PluginUpdateBean;
import org.jetbrains.intellij.pluginRepository.model.ProductFamily;
import org.jetbrains.intellij.pluginRepository.model.UpdateDeleteBean;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\b2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\u0010\u0015\u001a\u00060\u0011j\u0002`\u00162\n\u0010\u0017\u001a\u00060\u0011j\u0002`\u0012H\u0016J:\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0011j\u0002`\u0012\u0012\u0004\u0012\u00020\u00140\u00192 \u0010\u001a\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u0011j\u0002`\u0016\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u001b0\u0007H\u0016J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u0017\u001a\u00060\u0011j\u0002`\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/instances/PluginUpdateManagerInstance;", "Lorg/jetbrains/intellij/pluginRepository/PluginUpdateManager;", "service", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "<init>", "(Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;)V", "getUpdatesByVersionAndFamily", "", "Lorg/jetbrains/intellij/pluginRepository/model/PluginUpdateBean;", "xmlId", "", "Lorg/jetbrains/intellij/pluginRepository/model/StringPluginId;", "version", "family", "Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "getUpdateById", "id", "", "Lorg/jetbrains/intellij/pluginRepository/model/UpdateId;", "getIntellijUpdateMetadata", "Lorg/jetbrains/intellij/pluginRepository/model/IntellijUpdateMetadata;", "pluginId", "Lorg/jetbrains/intellij/pluginRepository/model/PluginId;", "updateId", "getIntellijUpdateMetadataBatch", "", "updateIds", "Lkotlin/Pair;", "deleteUpdate", "Lorg/jetbrains/intellij/pluginRepository/model/UpdateDeleteBean;", "rest"})
@SourceDebugExtension(value={"SMAP\nPluginUpdateManagerInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginUpdateManagerInstance.kt\norg/jetbrains/intellij/pluginRepository/internal/instances/PluginUpdateManagerInstance\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1557#2:43\n1628#2,3:44\n*S KotlinDebug\n*F\n+ 1 PluginUpdateManagerInstance.kt\norg/jetbrains/intellij/pluginRepository/internal/instances/PluginUpdateManagerInstance\n*L\n21#1:43\n21#1:44,3\n*E\n"})
public final class PluginUpdateManagerInstance
implements PluginUpdateManager {
    @NotNull
    private final PluginRepositoryService service;

    public PluginUpdateManagerInstance(@NotNull PluginRepositoryService service) {
        Intrinsics.checkNotNullParameter(service, "service");
        this.service = service;
    }

    @Override
    @NotNull
    public List<PluginUpdateBean> getUpdatesByVersionAndFamily(@NotNull String xmlId, @NotNull String version, @NotNull ProductFamily family) {
        Intrinsics.checkNotNullParameter(xmlId, "xmlId");
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter((Object)family, "family");
        List<PluginUpdateBean> list = RequestHelperKt.executeAndParseBody(this.service.getUpdatesByVersionAndFamily(xmlId, version, family.getId()), true);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public PluginUpdateBean getUpdateById(int id) {
        return RequestHelperKt.executeAndParseBody(this.service.getUpdateById(id), true);
    }

    @Override
    @Nullable
    public IntellijUpdateMetadata getIntellijUpdateMetadata(int pluginId, int updateId) {
        return RequestHelperKt.executeAndParseBody(this.service.getIntelliJUpdateMeta(pluginId, updateId), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, IntellijUpdateMetadata> getIntellijUpdateMetadataBatch(@NotNull List<Pair<Integer, Integer>> updateIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(updateIds, "updateIds");
        Iterable $this$map$iv = updateIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection2 = collection;
            boolean bl = false;
            int pluginId = ((Number)pair.component1()).intValue();
            int updateId = ((Number)pair.component2()).intValue();
            collection2.add(this.service.getIntelliJUpdateMeta(pluginId, updateId));
        }
        List calls = (List)collection;
        Collection responses = RequestHelperKt.executeExceptionallyBatch(calls).values();
        HashMap result2 = new HashMap();
        for (Response response : responses) {
            IntellijUpdateMetadata metadata2;
            if (!response.isSuccessful() || (metadata2 = (IntellijUpdateMetadata)response.body()) == null) continue;
            ((Map)result2).put(metadata2.getId(), metadata2);
        }
        return result2;
    }

    @Override
    @Nullable
    public UpdateDeleteBean deleteUpdate(int updateId) {
        return (UpdateDeleteBean)RequestHelperKt.executeAndParseBody$default(this.service.deleteUpdateById(updateId), false, 2, null);
    }
}

