/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.modifiers.Modifiers;
import com.jetbrains.pluginverifier.verifiers.BytecodeUtilKt;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.FieldAsm;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodAsm;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\"\u0010!\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00190\u00190\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010%R\u0014\u0010&\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010%R\u0014\u0010'\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0014\u0010(\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010%R\u0014\u0010)\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010%R\u0014\u0010*\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010%R\u0014\u0010+\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010%R\u0014\u0010,\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010%R\u0014\u0010-\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010%R\u0014\u0010.\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010%R\u0014\u0010/\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010%R\u0014\u00100\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001bR\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010 R\u0014\u0010=\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001bR\u0016\u0010?\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001bR\u0014\u0010A\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001bR\u0016\u0010C\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001bR\u0016\u0010E\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001b\u00a8\u0006G"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFileAsm;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "asmNode", "Lorg/objectweb/asm/tree/ClassNode;", "classFileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "(Lorg/objectweb/asm/tree/ClassNode;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;)V", "accessType", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "getAccessType", "()Lcom/jetbrains/pluginverifier/results/access/AccessType;", "annotations", "", "Lorg/objectweb/asm/tree/AnnotationNode;", "kotlin.jvm.PlatformType", "getAnnotations", "()Ljava/util/List;", "getAsmNode", "()Lorg/objectweb/asm/tree/ClassNode;", "getClassFileOrigin", "()Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "containingClassFile", "getContainingClassFile", "()Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFileAsm;", "enclosingClassName", "", "getEnclosingClassName", "()Ljava/lang/String;", "fields", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldAsm;", "getFields", "()Lkotlin/sequences/Sequence;", "interfaces", "getInterfaces", "isAbstract", "", "()Z", "isDeprecated", "isFinal", "isInterface", "isPackagePrivate", "isPrivate", "isProtected", "isPublic", "isStatic", "isSuperFlag", "isSynthetic", "javaPackageName", "getJavaPackageName", "javaVersion", "", "getJavaVersion", "()I", "location", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "getLocation", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "methods", "Lcom/jetbrains/pluginverifier/verifiers/resolution/MethodAsm;", "getMethods", "name", "getName", "nestHostClass", "getNestHostClass", "packageName", "getPackageName", "signature", "getSignature", "superName", "getSuperName", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nClassFileAsm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassFileAsm.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/ClassFileAsm\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class ClassFileAsm
implements ClassFile {
    @NotNull
    private final ClassNode asmNode;
    @NotNull
    private final FileOrigin classFileOrigin;

    public ClassFileAsm(@NotNull ClassNode asmNode, @NotNull FileOrigin classFileOrigin) {
        Intrinsics.checkNotNullParameter(asmNode, "asmNode");
        Intrinsics.checkNotNullParameter(classFileOrigin, "classFileOrigin");
        this.asmNode = asmNode;
        this.classFileOrigin = classFileOrigin;
    }

    @NotNull
    public final ClassNode getAsmNode() {
        return this.asmNode;
    }

    @Override
    @NotNull
    public FileOrigin getClassFileOrigin() {
        return this.classFileOrigin;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ClassLocation getLocation() {
        String string;
        String string2 = this.getName();
        String string3 = this.getSignature();
        if (string3 != null) {
            void it;
            String string4;
            String string5 = string4 = string3;
            String string6 = string2;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            string2 = string6;
            string = bl2 ? string4 : null;
        } else {
            string = null;
        }
        FileOrigin fileOrigin = this.getClassFileOrigin();
        Modifiers modifiers = new Modifiers(this.asmNode.access);
        String string7 = string;
        String string8 = string2;
        return new ClassLocation(string8, string7, modifiers, fileOrigin);
    }

    @Override
    @NotNull
    public ClassFileAsm getContainingClassFile() {
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.asmNode.name;
        Intrinsics.checkNotNullExpressionValue(string, "asmNode.name");
        return string;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return StringsKt.substringBeforeLast(this.getName(), '/', "");
    }

    @Override
    @NotNull
    public String getJavaPackageName() {
        return StringsKt.replace$default(this.getPackageName(), '/', '.', false, 4, null);
    }

    @NotNull
    public Sequence<MethodAsm> getMethods() {
        List<MethodNode> list = this.asmNode.methods;
        Intrinsics.checkNotNullExpressionValue(list, "asmNode.methods");
        return SequencesKt.map(CollectionsKt.asSequence((Iterable)list), (Function1)new Function1<MethodNode, MethodAsm>(this){
            final /* synthetic */ ClassFileAsm this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final MethodAsm invoke(MethodNode it) {
                ClassFile classFile = this.this$0;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                return new MethodAsm(classFile, it);
            }
        });
    }

    @NotNull
    public Sequence<FieldAsm> getFields() {
        List<FieldNode> list = this.asmNode.fields;
        Intrinsics.checkNotNullExpressionValue(list, "asmNode.fields");
        return SequencesKt.map(CollectionsKt.asSequence((Iterable)list), (Function1)new Function1<FieldNode, FieldAsm>(this){
            final /* synthetic */ ClassFileAsm this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final FieldAsm invoke(FieldNode it) {
                ClassFile classFile = this.this$0;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                return new FieldAsm(classFile, it);
            }
        });
    }

    @Override
    @NotNull
    public List<String> getInterfaces() {
        List<String> list = this.asmNode.interfaces;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public String getSuperName() {
        return this.asmNode.superName;
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.asmNode.signature;
    }

    @Override
    @NotNull
    public AccessType getAccessType() {
        return BytecodeUtilKt.getAccessType(this.asmNode.access);
    }

    @Override
    public int getJavaVersion() {
        return this.asmNode.version == 196653 ? 1 : this.asmNode.version - 44;
    }

    @Override
    @Nullable
    public String getEnclosingClassName() {
        Object v1;
        block2: {
            String outerClass = this.asmNode.outerClass;
            if (outerClass != null) {
                return outerClass;
            }
            List<InnerClassNode> list = this.asmNode.innerClasses;
            Intrinsics.checkNotNullExpressionValue(list, "asmNode.innerClasses");
            Iterable iterable = list;
            for (Object t2 : iterable) {
                InnerClassNode it = (InnerClassNode)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name, this.getName())) continue;
                v1 = t2;
                break block2;
            }
            v1 = null;
        }
        InnerClassNode innerClassNode = v1;
        return innerClassNode != null ? innerClassNode.outerName : null;
    }

    @Override
    @NotNull
    public List<AnnotationNode> getAnnotations() {
        List<AnnotationNode> list = this.asmNode.invisibleAnnotations;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Collection collection = list;
        List<AnnotationNode> list2 = this.asmNode.visibleAnnotations;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    @Override
    public boolean isAbstract() {
        return (this.asmNode.access & 0x400) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.asmNode.access & 0x10) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.asmNode.access & 0x200) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.asmNode.access & 1) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.asmNode.access & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.asmNode.access & 2) != 0;
    }

    @Override
    public boolean isPackagePrivate() {
        return (this.asmNode.access & 1) == 0 && (this.asmNode.access & 2) == 0 && (this.asmNode.access & 4) == 0;
    }

    @Override
    public boolean isDeprecated() {
        return (this.asmNode.access & 0x20000) != 0;
    }

    @Override
    public boolean isSuperFlag() {
        return (this.asmNode.access & 0x20) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.asmNode.access & 0x1000) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.asmNode.access & 8) != 0;
    }

    @Override
    @Nullable
    public String getNestHostClass() {
        return this.asmNode.nestHostClass;
    }
}

