/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.deprecated;

import com.jetbrains.pluginverifier.results.location.LocationToReferenceKt;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecatedApiUsage;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecationInfo;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecatedMethodOverridden;", "Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecatedApiUsage;", "apiElement", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "usageLocation", "deprecationInfo", "Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecationInfo;", "(Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecationInfo;)V", "getApiElement", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "apiReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "getApiReference", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUsageLocation", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
public final class DeprecatedMethodOverridden
extends DeprecatedApiUsage {
    @NotNull
    private final MethodLocation apiElement;
    @NotNull
    private final MethodLocation usageLocation;

    public DeprecatedMethodOverridden(@NotNull MethodLocation apiElement, @NotNull MethodLocation usageLocation, @NotNull DeprecationInfo deprecationInfo) {
        Intrinsics.checkNotNullParameter(apiElement, "apiElement");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        Intrinsics.checkNotNullParameter(deprecationInfo, "deprecationInfo");
        super(deprecationInfo);
        this.apiElement = apiElement;
        this.usageLocation = usageLocation;
    }

    @Override
    @NotNull
    public MethodLocation getApiElement() {
        return this.apiElement;
    }

    @Override
    @NotNull
    public MethodLocation getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Deprecated method is overridden";
    }

    @Override
    @NotNull
    public MethodReference getApiReference() {
        return LocationToReferenceKt.toReference(this.getApiElement());
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Deprecated method " + LocationsPresentationKt.formatMethodLocation(this.getApiElement(), HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.NO_RETURN_TYPE, MethodParameterNameOption.NO_PARAMETER_NAMES) + " is overridden";
    }

    @Override
    @NotNull
    public String getFullDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_fullDescription__u24lambda_u240.append("Deprecated method " + LocationsPresentationKt.formatMethodLocation(this.getApiElement(), HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.WITH_PARAM_NAMES_IF_AVAILABLE));
        $this$_get_fullDescription__u24lambda_u240.append(" is overridden in class " + LocationsPresentationKt.formatClassLocation(this.getUsageLocation().getHostClass(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS));
        if (this.getDeprecationInfo().getForRemoval()) {
            $this$_get_fullDescription__u24lambda_u240.append(". This method will be removed in ");
            String string = this.getDeprecationInfo().getUntilVersion();
            if (string == null) {
                string = "a future release";
            }
            $this$_get_fullDescription__u24lambda_u240.append(string);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof DeprecatedMethodOverridden && Intrinsics.areEqual(this.getApiReference(), ((DeprecatedMethodOverridden)other).getApiReference()) && Intrinsics.areEqual(this.getApiElement(), ((DeprecatedMethodOverridden)other).getApiElement()) && Intrinsics.areEqual(this.getUsageLocation(), ((DeprecatedMethodOverridden)other).getUsageLocation()) && Intrinsics.areEqual(this.getDeprecationInfo(), ((DeprecatedMethodOverridden)other).getDeprecationInfo());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getApiReference(), this.getApiElement(), this.getUsageLocation(), this.getDeprecationInfo()};
        return Objects.hash(objectArray);
    }
}

