/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.downloader;

import java.net.http.HttpResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\bH\u0002\u001a\u001a\u0010\t\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\b2\b\b\u0002\u0010\n\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"FILENAME", "", "urlPathExtensions", "", "guessExtensionByPath", "path", "contentLength", "", "Ljava/net/http/HttpResponse;", "guessExtension", "defaultExtension", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nUrlDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlDownloader.kt\ncom/jetbrains/pluginverifier/repository/downloader/UrlDownloaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n295#2,2:182\n*S KotlinDebug\n*F\n+ 1 UrlDownloader.kt\ncom/jetbrains/pluginverifier/repository/downloader/UrlDownloaderKt\n*L\n180#1:182,2\n*E\n"})
public final class UrlDownloaderKt {
    @NotNull
    private static final String FILENAME = "filename=";
    @NotNull
    private static final List<String> urlPathExtensions;

    private static final long contentLength(HttpResponse<?> $this$contentLength) {
        return $this$contentLength.headers().firstValueAsLong("Content-Length").orElse(-1L);
    }

    @NotNull
    public static final String guessExtension(@NotNull HttpResponse<?> $this$guessExtension, @NotNull String defaultExtension) {
        String path;
        String extension;
        Intrinsics.checkNotNullParameter($this$guessExtension, "<this>");
        Intrinsics.checkNotNullParameter(defaultExtension, "defaultExtension");
        String contentDisposition = $this$guessExtension.headers().firstValue("Content-Disposition").orElse(null);
        if (contentDisposition != null && StringsKt.contains$default((CharSequence)contentDisposition, FILENAME, false, 2, null) && (extension = UrlDownloaderKt.guessExtensionByPath(path = StringsKt.removeSurrounding(StringsKt.substringBefore$default(StringsKt.substringAfter$default(contentDisposition, FILENAME, null, 2, null), ";", null, 2, null), (CharSequence)"\""))) != null) {
            return extension;
        }
        String contentType = $this$guessExtension.headers().firstValue("Content-Type").orElse("application/octet-stream");
        if (Intrinsics.areEqual(contentType, "application/java-archive") || Intrinsics.areEqual(contentType, "application/x-java-archive")) {
            return "jar";
        }
        if (Intrinsics.areEqual(contentType, "application/json")) {
            return "json";
        }
        String path2 = $this$guessExtension.request().uri().getRawPath();
        Intrinsics.checkNotNullExpressionValue(path2, "path");
        String extension2 = UrlDownloaderKt.guessExtensionByPath(path2);
        if (extension2 != null) {
            return extension2;
        }
        return defaultExtension;
    }

    public static /* synthetic */ String guessExtension$default(HttpResponse httpResponse, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "zip";
        }
        return UrlDownloaderKt.guessExtension(httpResponse, string);
    }

    private static final String guessExtensionByPath(String path) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = urlPathExtensions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default(path, "." + it, false, 2, null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final /* synthetic */ long access$contentLength(HttpResponse $receiver) {
        return UrlDownloaderKt.contentLength($receiver);
    }

    static {
        String[] stringArray = new String[]{"jar", "zip", "tar.gz", "tar.bz2", "txt", "html", "xml", "json"};
        urlPathExtensions = CollectionsKt.listOf(stringArray);
    }
}

