/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies.resolution;

import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.PluginVersionSelector;
import com.jetbrains.pluginverifier.misc.RetryUtilKt;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.dependency.DependencyPluginRepository;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/resolution/RepositoryDependencyFinder;", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "pluginVersionSelector", "Lcom/jetbrains/pluginverifier/dependencies/resolution/PluginVersionSelector;", "pluginDetailsCache", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "(Lcom/jetbrains/pluginverifier/repository/PluginRepository;Lcom/jetbrains/pluginverifier/dependencies/resolution/PluginVersionSelector;Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;)V", "Lcom/jetbrains/pluginverifier/repository/repositories/dependency/DependencyPluginRepository;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "convertResult", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder$Result;", "selectResult", "Lcom/jetbrains/pluginverifier/dependencies/resolution/PluginVersionSelector$Result;", "findPluginDependency", "dependency", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "dependencyId", "isModule", "", "verifier-intellij"})
public final class RepositoryDependencyFinder
implements DependencyFinder {
    @NotNull
    private final PluginVersionSelector pluginVersionSelector;
    @NotNull
    private final PluginDetailsCache pluginDetailsCache;
    @NotNull
    private final DependencyPluginRepository pluginRepository;

    public RepositoryDependencyFinder(@NotNull PluginRepository pluginRepository, @NotNull PluginVersionSelector pluginVersionSelector, @NotNull PluginDetailsCache pluginDetailsCache) {
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        Intrinsics.checkNotNullParameter(pluginVersionSelector, "pluginVersionSelector");
        Intrinsics.checkNotNullParameter(pluginDetailsCache, "pluginDetailsCache");
        this.pluginVersionSelector = pluginVersionSelector;
        this.pluginDetailsCache = pluginDetailsCache;
        this.pluginRepository = new DependencyPluginRepository(pluginRepository);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.pluginRepository.toString();
    }

    @Override
    @NotNull
    public DependencyFinder.Result findPluginDependency(@NotNull String dependencyId, boolean isModule) {
        Intrinsics.checkNotNullParameter(dependencyId, "dependencyId");
        return (DependencyFinder.Result)RetryUtilKt.retry$default(this, "Resolve dependency " + dependencyId, null, new Function1<RepositoryDependencyFinder, DependencyFinder.Result>(dependencyId, isModule){
            final /* synthetic */ String $dependencyId;
            final /* synthetic */ boolean $isModule;
            {
                this.$dependencyId = $dependencyId;
                this.$isModule = $isModule;
                super(1);
            }

            @NotNull
            public final DependencyFinder.Result invoke(@NotNull RepositoryDependencyFinder $this$retry) {
                Intrinsics.checkNotNullParameter($this$retry, "$this$retry");
                if (StringsKt.isBlank(this.$dependencyId)) {
                    return new DependencyFinder.Result.NotFound("Invalid empty dependency ID");
                }
                return this.$isModule ? RepositoryDependencyFinder.access$convertResult($this$retry, RepositoryDependencyFinder.access$getPluginVersionSelector$p($this$retry).selectPluginByModuleId(this.$dependencyId, RepositoryDependencyFinder.access$getPluginRepository$p($this$retry))) : RepositoryDependencyFinder.access$convertResult($this$retry, RepositoryDependencyFinder.access$getPluginVersionSelector$p($this$retry).selectPluginVersion(this.$dependencyId, RepositoryDependencyFinder.access$getPluginRepository$p($this$retry)));
            }
        }, 2, null);
    }

    @Override
    @NotNull
    public DependencyFinder.Result findPluginDependency(@NotNull PluginDependency dependency) {
        Intrinsics.checkNotNullParameter(dependency, "dependency");
        return this.findPluginDependency(dependency.getId(), dependency.isModule());
    }

    private final DependencyFinder.Result convertResult(PluginVersionSelector.Result selectResult2) {
        DependencyFinder.Result result2;
        PluginVersionSelector.Result result3 = selectResult2;
        if (result3 instanceof PluginVersionSelector.Result.Selected) {
            PluginDetailsCache.Result cacheEntryResult = this.pluginDetailsCache.getPluginDetailsCacheEntry(((PluginVersionSelector.Result.Selected)selectResult2).getPluginInfo());
            result2 = new DependencyFinder.Result.DetailsProvided(cacheEntryResult);
        } else if (result3 instanceof PluginVersionSelector.Result.NotFound) {
            result2 = new DependencyFinder.Result.NotFound(((PluginVersionSelector.Result.NotFound)selectResult2).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    public static final /* synthetic */ DependencyFinder.Result access$convertResult(RepositoryDependencyFinder $this, PluginVersionSelector.Result selectResult2) {
        return $this.convertResult(selectResult2);
    }

    public static final /* synthetic */ PluginVersionSelector access$getPluginVersionSelector$p(RepositoryDependencyFinder $this) {
        return $this.pluginVersionSelector;
    }

    public static final /* synthetic */ DependencyPluginRepository access$getPluginRepository$p(RepositoryDependencyFinder $this) {
        return $this.pluginRepository;
    }
}

