/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.xinclude;

import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/xinclude/MetaInfResourceResolver;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "delegateResolver", "(Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;)V", "getParent", "Ljava/nio/file/Path;", "path", "resolveResource", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result;", "relativePath", "", "basePath", "structure-intellij"})
public final class MetaInfResourceResolver
implements ResourceResolver {
    @NotNull
    private final ResourceResolver delegateResolver;

    public MetaInfResourceResolver(@NotNull ResourceResolver delegateResolver2) {
        Intrinsics.checkNotNullParameter(delegateResolver2, "delegateResolver");
        this.delegateResolver = delegateResolver2;
    }

    @Override
    @NotNull
    public ResourceResolver.Result resolveResource(@NotNull String relativePath, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Path path = this.getParent(basePath);
        if (path == null) {
            return ResourceResolver.Result.NotFound.INSTANCE;
        }
        Path parentPath = path;
        Path path2 = parentPath.resolve("META-INF").resolve(relativePath);
        Intrinsics.checkNotNullExpressionValue(path2, "parentPath.resolve(META_INF).resolve(relativePath)");
        return this.delegateResolver.resolveResource(relativePath, path2);
    }

    private final Path getParent(Path path) {
        Path path2;
        Path parent = path.getParent();
        if (parent == null && !Intrinsics.areEqual(path.getFileSystem(), FileSystems.getDefault())) {
            Iterable<Path> iterable = path.getFileSystem().getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, "path.fileSystem.rootDirectories");
            path2 = CollectionsKt.first(iterable);
        } else {
            path2 = parent;
        }
        return path2;
    }
}

