/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.problems;

import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.Module;
import com.jetbrains.plugin.structure.intellij.problems.ModuleDescriptorProblem;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/problems/ModuleDescriptorProblem;", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "module", "Lcom/jetbrains/plugin/structure/intellij/plugin/Module;", "errors", "", "(Lcom/jetbrains/plugin/structure/intellij/plugin/Module;Ljava/util/List;)V", "level", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem$Level;", "getLevel", "()Lcom/jetbrains/plugin/structure/base/problems/PluginProblem$Level;", "message", "", "getMessage", "()Ljava/lang/String;", "structure-intellij"})
public final class ModuleDescriptorProblem
extends PluginProblem {
    @NotNull
    private final Module module;
    @NotNull
    private final List<PluginProblem> errors;

    public ModuleDescriptorProblem(@NotNull Module module, @NotNull List<? extends PluginProblem> errors) {
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(errors, "errors");
        this.module = module;
        this.errors = errors;
    }

    @Override
    @NotNull
    public PluginProblem.Level getLevel() {
        return PluginProblem.Level.WARNING;
    }

    @Override
    @NotNull
    public String getMessage() {
        String errorStr = FormatUtilsKt.pluralize("problem", this.errors.size());
        return "Module '" + this.module.getName() + "' has " + this.errors.size() + " " + errorStr + ": " + CollectionsKt.joinToString$default(this.errors, null, null, null, 0, null, message.1.INSTANCE, 31, null);
    }
}

