/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.IncorrectZipOrJarFile;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.telemetry.MutablePluginTelemetry;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.ModuleDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.OptionalDependencyResolver;
import com.jetbrains.plugin.structure.intellij.plugin.PluginArchiveManager;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.PluginFileNotFoundException;
import com.jetbrains.plugin.structure.intellij.plugin.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.ContentModuleLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarModuleLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarOrDirectoryPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.LibDirectoryPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.ModuleFromDescriptorLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginDirectoryLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoaderProvider;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModuleLoadingResults;
import com.jetbrains.plugin.structure.intellij.problems.IntelliJPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.PluginArchiveResource;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ:\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u001dJ\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J0\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ0\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010*\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010+\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010,\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010.\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010/\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00100\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u00101\u001a\u00020-*\u00020&2\u0006\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u000204H\u0002J\u001c\u00105\u001a\u00020-*\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "myResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "pluginArchiveManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "contentModuleLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/ContentModuleLoader;", "jarModuleLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarModuleLoader;", "jarOrDirLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarOrDirectoryPluginLoader;", "moduleFromDescriptorLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/ModuleFromDescriptorLoader;", "optionalDependencyResolver", "Lcom/jetbrains/plugin/structure/intellij/plugin/OptionalDependencyResolver;", "pluginLoaderRegistry", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider;", "createBundledModule", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginFile", "Ljava/nio/file/Path;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "descriptorPath", "", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "createBundledPlugin", "fallbackPluginId", "createPlugin", "validateDescriptor", "", "extractPluginCreator", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "resourceResolver", "getInvalidPluginFileCreator", "pluginFileName", "getPluginCreator", "getPluginCreatorWithResult", "resolveContentModules", "", "contentModulesOwner", "resolveOptionalDependencies", "pluginCreator", "addContentModule", "resolvedContentModule", "moduleDescriptor", "Lcom/jetbrains/plugin/structure/intellij/plugin/ModuleDescriptor;", "setTelemetry", "pluginCreationDurationInMillis", "", "Companion", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nIdePluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager\n+ 2 PluginLoaderProvider.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,294:1\n21#2:295\n21#2:296\n21#2:297\n1855#3,2:298\n1855#3,2:300\n1#4:302\n17#5,6:303\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager\n*L\n65#1:295\n66#1:296\n67#1:297\n106#1,2:298\n109#1,2:300\n207#1,6:303\n*E\n"})
public final class IdePluginManager
implements PluginManager<IdePlugin> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceResolver myResourceResolver;
    @NotNull
    private final PluginArchiveManager pluginArchiveManager;
    @NotNull
    private final JarFileSystemProvider fileSystemProvider;
    @NotNull
    private final PluginLoaderProvider pluginLoaderRegistry;
    @NotNull
    private final ModuleFromDescriptorLoader moduleFromDescriptorLoader;
    @NotNull
    private final JarModuleLoader jarModuleLoader;
    @NotNull
    private final JarOrDirectoryPluginLoader jarOrDirLoader;
    @NotNull
    private final ContentModuleLoader contentModuleLoader;
    @NotNull
    private final OptionalDependencyResolver optionalDependencyResolver;
    private static final Logger LOG = LoggerFactory.getLogger(IdePluginManager.class);
    @NotNull
    public static final String PLUGIN_XML = "plugin.xml";
    @NotNull
    public static final String META_INF = "META-INF";

    /*
     * WARNING - void declaration
     */
    private IdePluginManager(ResourceResolver myResourceResolver, PluginArchiveManager pluginArchiveManager, JarFileSystemProvider fileSystemProvider) {
        void $this$pluginLoaderRegistry_u24lambda_u240;
        PluginLoaderProvider pluginLoaderProvider;
        this.myResourceResolver = myResourceResolver;
        this.pluginArchiveManager = pluginArchiveManager;
        this.fileSystemProvider = fileSystemProvider;
        PluginLoaderProvider pluginLoaderProvider2 = pluginLoaderProvider = new PluginLoaderProvider();
        IdePluginManager idePluginManager = this;
        boolean bl = false;
        $this$pluginLoaderRegistry_u24lambda_u240.register$structure_intellij(JarPluginLoader.Context.class, new JarPluginLoader(this.fileSystemProvider));
        $this$pluginLoaderRegistry_u24lambda_u240.register$structure_intellij(JarModuleLoader.Context.class, new JarModuleLoader(this.fileSystemProvider));
        $this$pluginLoaderRegistry_u24lambda_u240.register$structure_intellij(PluginDirectoryLoader.Context.class, new PluginDirectoryLoader((PluginLoaderProvider)$this$pluginLoaderRegistry_u24lambda_u240));
        $this$pluginLoaderRegistry_u24lambda_u240.register$structure_intellij(LibDirectoryPluginLoader.Context.class, new LibDirectoryPluginLoader((PluginLoaderProvider)$this$pluginLoaderRegistry_u24lambda_u240, this.fileSystemProvider));
        $this$pluginLoaderRegistry_u24lambda_u240.register$structure_intellij(ModuleFromDescriptorLoader.Context.class, new ModuleFromDescriptorLoader());
        $this$pluginLoaderRegistry_u24lambda_u240.register$structure_intellij(JarOrDirectoryPluginLoader.Context.class, new JarOrDirectoryPluginLoader((PluginLoaderProvider)$this$pluginLoaderRegistry_u24lambda_u240));
        idePluginManager.pluginLoaderRegistry = pluginLoaderProvider;
        PluginLoaderProvider this_$iv = this.pluginLoaderRegistry;
        boolean $i$f$get$structure_intellij = false;
        com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader<ModuleFromDescriptorLoader.Context> pluginLoader = this_$iv.get$structure_intellij(ModuleFromDescriptorLoader.Context.class);
        if (pluginLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.ModuleFromDescriptorLoader");
        }
        this.moduleFromDescriptorLoader = (ModuleFromDescriptorLoader)((com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader)((ModuleFromDescriptorLoader)pluginLoader));
        this_$iv = this.pluginLoaderRegistry;
        $i$f$get$structure_intellij = false;
        com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader<JarModuleLoader.Context> pluginLoader2 = this_$iv.get$structure_intellij(JarModuleLoader.Context.class);
        if (pluginLoader2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.JarModuleLoader");
        }
        this.jarModuleLoader = (JarModuleLoader)((com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader)((JarModuleLoader)pluginLoader2));
        this_$iv = this.pluginLoaderRegistry;
        $i$f$get$structure_intellij = false;
        com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader<JarOrDirectoryPluginLoader.Context> pluginLoader3 = this_$iv.get$structure_intellij(JarOrDirectoryPluginLoader.Context.class);
        if (pluginLoader3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.JarOrDirectoryPluginLoader");
        }
        this.jarOrDirLoader = (JarOrDirectoryPluginLoader)((com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader)((JarOrDirectoryPluginLoader)pluginLoader3));
        this.contentModuleLoader = new ContentModuleLoader(this.jarOrDirLoader, this.moduleFromDescriptorLoader);
        this.optionalDependencyResolver = new OptionalDependencyResolver(new PluginLoader(this){
            final /* synthetic */ IdePluginManager this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public PluginCreator load(@NotNull Path pluginFile, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver) {
                Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
                Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
                Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
                Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
                return IdePluginManager.access$getJarOrDirLoader$p(this.this$0).loadPlugin(new JarOrDirectoryPluginLoader.Context(pluginFile, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, false, 64, null));
            }
        });
    }

    /* synthetic */ IdePluginManager(ResourceResolver resourceResolver, PluginArchiveManager pluginArchiveManager, JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            jarFileSystemProvider = SingletonCachingJarFileSystemProvider.INSTANCE;
        }
        this(resourceResolver, pluginArchiveManager, jarFileSystemProvider);
    }

    private final void resolveOptionalDependencies(Path pluginFile, PluginCreator pluginCreator, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        if (pluginCreator.isSuccess()) {
            this.optionalDependencyResolver.resolveOptionalDependencies(pluginCreator, pluginFile, resourceResolver, problemResolver);
        }
    }

    private final void resolveContentModules(Path pluginFile, PluginCreator contentModulesOwner, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        Object it;
        ContentModuleLoadingResults $this$resolveContentModules_u24lambda_u243 = this.contentModuleLoader.resolveContentModules$structure_intellij(pluginFile, contentModulesOwner, resourceResolver, problemResolver);
        boolean bl = false;
        Iterable $this$forEach$iv = $this$resolveContentModules_u24lambda_u243.getContentModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ContentModuleLoadingResults.ResolvedContentModuleWithDescriptor)element$iv;
            boolean bl2 = false;
            this.addContentModule(contentModulesOwner, ((ContentModuleLoadingResults.ResolvedContentModuleWithDescriptor)it).getContentModule(), ((ContentModuleLoadingResults.ResolvedContentModuleWithDescriptor)it).getDescriptor());
        }
        $this$forEach$iv = $this$resolveContentModules_u24lambda_u243.getProblems();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PluginProblem)element$iv;
            boolean bl3 = false;
            contentModulesOwner.registerProblem$structure_intellij((PluginProblem)it);
        }
    }

    private final void addContentModule(PluginCreator $this$addContentModule, IdePlugin resolvedContentModule, ModuleDescriptor moduleDescriptor) {
        $this$addContentModule.getPlugin$structure_intellij().getModulesDescriptors().add(moduleDescriptor);
        $this$addContentModule.getPlugin$structure_intellij().getDefinedModules().add(moduleDescriptor.getName());
        $this$addContentModule.mergeContent$structure_intellij(resolvedContentModule);
    }

    private final PluginCreator extractPluginCreator(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        PluginArchiveManager.Result archive = this.pluginArchiveManager.extractArchive(pluginFile);
        if (archive instanceof PluginArchiveManager.Result.Extracted) {
            PluginCreator pluginCreator2;
            PluginCreator $this$extractPluginCreator_u24lambda_u244 = pluginCreator2 = this.getPluginCreator(((PluginArchiveManager.Result.Extracted)archive).getExtractedPath(), descriptorPath, validateDescriptor, resourceResolver, problemResolver);
            boolean bl = false;
            ((Collection)$this$extractPluginCreator_u24lambda_u244.getResources$structure_intellij()).add(PluginArchiveResource.Companion.of(pluginFile, ((PluginArchiveManager.Result.Extracted)archive).getExtractedPath(), $this$extractPluginCreator_u24lambda_u244.getPlugin$structure_intellij()));
            pluginCreator = pluginCreator2;
        } else if (archive instanceof PluginArchiveManager.Result.Failed) {
            pluginCreator = PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName(pluginFile), descriptorPath, ((PluginArchiveManager.Result.Failed)archive).getProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginCreator;
    }

    @Override
    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        return IdePluginManager.createPlugin$default(this, pluginFile, true, null, null, 12, null);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile, boolean validateDescriptor, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) throws PluginFileNotFoundException {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
        PluginCreator pluginCreator = this.getPluginCreatorWithResult(pluginFile, validateDescriptor, descriptorPath, problemResolver);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createPlugin$default(IdePluginManager idePluginManager, Path path, boolean bl, String string, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) throws PluginFileNotFoundException {
        if ((n & 4) != 0) {
            string = PLUGIN_XML;
        }
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        return idePluginManager.createPlugin(path, bl, string, pluginCreationResultResolver);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledPlugin(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver, @Nullable String fallbackPluginId) throws PluginFileNotFoundException {
        PluginCreator pluginCreator;
        block0: {
            Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
            Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            pluginCreator = this.getPluginCreatorWithResult(pluginFile, false, descriptorPath, problemResolver);
            String string = ideVersion.asStringWithoutProductCode();
            Intrinsics.checkNotNullExpressionValue(string, "ideVersion.asStringWithoutProductCode()");
            pluginCreator.setPluginVersion(string);
            String string2 = fallbackPluginId;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            pluginCreator.setPluginIdIfNull(it);
        }
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createBundledPlugin$default(IdePluginManager idePluginManager, Path path, IdeVersion ideVersion, String string, PluginCreationResultResolver pluginCreationResultResolver, String string2, int n, Object object) throws PluginFileNotFoundException {
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return idePluginManager.createBundledPlugin(path, ideVersion, string, pluginCreationResultResolver, string2);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledModule(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
        PluginCreator $this$createBundledModule_u24lambda_u246 = pluginCreator = this.jarModuleLoader.loadPlugin(new JarModuleLoader.Context(pluginFile, descriptorPath, this.myResourceResolver, problemResolver));
        boolean bl = false;
        String string = ideVersion.asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue(string, "ideVersion.asStringWithoutProductCode()");
        $this$createBundledModule_u24lambda_u246.setPluginVersion(string);
        $this$createBundledModule_u24lambda_u246.setOriginalFile(pluginFile);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createBundledModule$default(IdePluginManager idePluginManager, Path path, IdeVersion ideVersion, String string, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) {
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        return idePluginManager.createBundledModule(path, ideVersion, string, pluginCreationResultResolver);
    }

    private final PluginCreator getPluginCreatorWithResult(Path pluginFile, boolean validateDescriptor, String descriptorPath, PluginCreationResultResolver problemResolver) throws PluginFileNotFoundException {
        if (!FileUtilKt.exists(pluginFile)) {
            throw new PluginFileNotFoundException(pluginFile);
        }
        PluginCreator pluginCreator = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        pluginCreator = FileUtilKt.isZip(pluginFile) ? this.extractPluginCreator(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, problemResolver) : (FileUtilKt.isJar(pluginFile) || FileUtilKt.isDirectory(pluginFile) ? this.getPluginCreator(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, problemResolver) : this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName(pluginFile), descriptorPath));
        pluginCreator.setOriginalFile(pluginFile);
        long pluginCreationDuration = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        this.setTelemetry(pluginCreator, pluginFile, pluginCreationDuration);
        return pluginCreator;
    }

    private final PluginCreator getPluginCreator(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator = this.jarOrDirLoader.loadPlugin(new JarOrDirectoryPluginLoader.Context(pluginFile, descriptorPath, validateDescriptor, resourceResolver, null, problemResolver, false, 64, null));
        this.resolveOptionalDependencies(pluginFile, pluginCreator, this.myResourceResolver, problemResolver);
        this.resolveContentModules(pluginFile, pluginCreator, this.myResourceResolver, problemResolver);
        return pluginCreator;
    }

    private final PluginCreator getInvalidPluginFileCreator(String pluginFileName, String descriptorPath) {
        return PluginCreator.Companion.createInvalidPlugin(pluginFileName, descriptorPath, (PluginProblem)new IncorrectZipOrJarFile(pluginFileName));
    }

    private final void setTelemetry(PluginCreator $this$setTelemetry, Path pluginFile, long pluginCreationDurationInMillis) {
        MutablePluginTelemetry $this$setTelemetry_u24lambda_u249 = $this$setTelemetry.getTelemetry();
        boolean bl = false;
        $this$setTelemetry_u24lambda_u249.setParsingDuration(Duration.ofMillis(pluginCreationDurationInMillis));
        $this$setTelemetry_u24lambda_u249.setArchiveFileSize(FileUtilKt.getPluginSize(pluginFile));
    }

    @Override
    @Deprecated(message="Use method with java.nio.Path instead of java.io.File", replaceWith=@ReplaceWith(expression="createPlugin(pluginFile.toPath())", imports={}))
    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull File pluginFile) {
        return PluginManager.DefaultImpls.createPlugin(this, pluginFile);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager() {
        return Companion.createManager();
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
        return Companion.createManager(resourceResolver);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull Path extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory, @NotNull JarFileSystemProvider fileSystemProvider) {
        return Companion.createManager(resourceResolver, extractDirectory, fileSystemProvider);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull PluginArchiveManager pluginArchiveManager, @NotNull JarFileSystemProvider fileSystemProvider) {
        return Companion.createManager(resourceResolver, pluginArchiveManager, fileSystemProvider);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(expression="createManager(extractDirectory.toPath())", imports={}))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull File extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(expression="createManager(resourceResolver, extractDirectory.toPath())", imports={}))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    public /* synthetic */ IdePluginManager(ResourceResolver myResourceResolver, PluginArchiveManager pluginArchiveManager, JarFileSystemProvider fileSystemProvider, DefaultConstructorMarker $constructor_marker) {
        this(myResourceResolver, pluginArchiveManager, fileSystemProvider);
    }

    public static final /* synthetic */ JarOrDirectoryPluginLoader access$getJarOrDirLoader$p(IdePluginManager $this) {
        return $this.jarOrDirLoader;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0013H\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0013H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "META_INF", "", "PLUGIN_XML", "createManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "pluginArchiveManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "extractDirectory", "Ljava/io/File;", "Ljava/nio/file/Path;", "structure-intellij"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager() {
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            return this.createManager(resourceResolver, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, extractDirectory);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            return new IdePluginManager(resourceResolver, new PluginArchiveManager(extractDirectory, false, 2, null), null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory, @NotNull JarFileSystemProvider fileSystemProvider) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
            return new IdePluginManager(resourceResolver, new PluginArchiveManager(extractDirectory, false, 2, null), fileSystemProvider, null);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull PluginArchiveManager pluginArchiveManager, @NotNull JarFileSystemProvider fileSystemProvider) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(pluginArchiveManager, "pluginArchiveManager");
            Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
            return new IdePluginManager(resourceResolver, pluginArchiveManager, fileSystemProvider, null);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(expression="createManager(extractDirectory.toPath())", imports={}))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull File extractDirectory) {
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            ResourceResolver resourceResolver = DefaultResourceResolver.INSTANCE;
            Path path = extractDirectory.toPath();
            Intrinsics.checkNotNullExpressionValue(path, "extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(expression="createManager(resourceResolver, extractDirectory.toPath())", imports={}))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            Path path = extractDirectory.toPath();
            Intrinsics.checkNotNullExpressionValue(path, "extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

