/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.charseq;

import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0096\u0002J\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/charseq/CharBufferCharSequence;", "", "buffer", "Ljava/nio/CharBuffer;", "startIndex", "", "endIndex", "(Ljava/nio/CharBuffer;II)V", "length", "getLength", "()I", "get", "", "index", "subSequence", "subStart", "subEnd", "toString", "", "structure-base"})
public final class CharBufferCharSequence
implements CharSequence {
    @NotNull
    private final CharBuffer buffer;
    private final int startIndex;
    private final int endIndex;

    public CharBufferCharSequence(@NotNull CharBuffer buffer, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.buffer = buffer;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        if (this.startIndex < 0 || this.endIndex > this.buffer.length() || this.startIndex > this.endIndex) {
            throw new IndexOutOfBoundsException("Invalid start or end index");
        }
    }

    public int getLength() {
        return this.endIndex - this.startIndex;
    }

    public char get(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        return this.buffer.get(this.startIndex + index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int subStart, int subEnd) {
        if (subStart < 0 || subEnd > this.length() || subStart > subEnd) {
            throw new IndexOutOfBoundsException("Invalid subSequence range");
        }
        return new CharBufferCharSequence(this.buffer, this.startIndex + subStart, this.startIndex + subEnd);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.buffer.subSequence(this.startIndex, this.endIndex).toString();
        Intrinsics.checkNotNullExpressionValue(string, "buffer.subSequence(start\u2026dex, endIndex).toString()");
        return string;
    }
}

