/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.DatatypeFactory;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.StringType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.TypeIncubator;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CommandLineTester {
    public static void help() {
        System.out.println("base <typeName>\n  set base type name.\n  this will reset all the facets you've added\nadd <facet name> <facet value>\n  add facet\ntest <value>\n  test if the value is accepted by the current base type and facets\nquit\n  quit this tool");
    }

    public static void main(String[] args2) throws IOException {
        System.out.println("XML Schema Part 2 command line tool");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        TypeIncubator incubator = new TypeIncubator(StringType.theInstance);
        block6: while (true) {
            try {
                while (true) {
                    XSDatatype dt;
                    System.out.print("-->");
                    String s2 = in.readLine();
                    StringTokenizer tokens = new StringTokenizer(s2);
                    String cmd = tokens.nextToken();
                    if (cmd.equals("base")) {
                        String typeName = tokens.nextToken();
                        dt = DatatypeFactory.getTypeByName(typeName);
                        if (dt == null) {
                            System.out.println("no such type");
                            continue;
                        }
                        incubator = new TypeIncubator(dt);
                        continue;
                    }
                    if (cmd.equals("add")) {
                        String facetName = tokens.nextToken();
                        String facetValue = tokens.nextToken();
                        incubator.addFacet(facetName, facetValue, false, null);
                        continue;
                    }
                    if (cmd.equals("test")) {
                        String value = tokens.nextToken();
                        dt = incubator.derive("", "anonymous");
                        if (dt.isValid(value, null)) {
                            System.out.println("valid value");
                            continue;
                        }
                        try {
                            dt.checkValid(value, null);
                            System.out.println("valid");
                            continue block6;
                        }
                        catch (DatatypeException diag) {
                            if (diag.getMessage() == null) {
                                System.out.println("invalid: no diagnosys available");
                                continue;
                            }
                            System.out.println("invalid: " + diag.getMessage());
                            continue;
                        }
                    }
                    if (cmd.equals("quit")) {
                        return;
                    }
                    CommandLineTester.help();
                }
            }
            catch (DatatypeException bte) {
                System.out.println("DatatypeException: " + bte.getMessage());
                continue;
            }
            catch (NoSuchElementException nse) {
                System.out.println("???");
                CommandLineTester.help();
                continue;
            }
            catch (RuntimeException rte) {
                rte.printStackTrace();
                continue;
            }
            break;
        }
    }
}

