/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BaseShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraClosestFirstIterator;
import org.jgrapht.alg.util.Pair;
import org.jheaps.AddressableHeap;
import org.jheaps.tree.PairingHeap;

public final class DijkstraShortestPath<V, E>
extends BaseShortestPathAlgorithm<V, E> {
    private final double radius;
    private final Supplier<AddressableHeap<Double, Pair<V, E>>> heapSupplier;

    public DijkstraShortestPath(Graph<V, E> graph) {
        this(graph, Double.POSITIVE_INFINITY, PairingHeap::new);
    }

    public DijkstraShortestPath(Graph<V, E> graph, double radius) {
        this(graph, radius, PairingHeap::new);
    }

    public DijkstraShortestPath(Graph<V, E> graph, Supplier<AddressableHeap<Double, Pair<V, E>>> heapSupplier) {
        this(graph, Double.POSITIVE_INFINITY, heapSupplier);
    }

    public DijkstraShortestPath(Graph<V, E> graph, double radius, Supplier<AddressableHeap<Double, Pair<V, E>>> heapSupplier) {
        super(graph);
        if (radius < 0.0) {
            throw new IllegalArgumentException("Radius must be non-negative");
        }
        this.heapSupplier = heapSupplier;
        this.radius = radius;
    }

    public static <V, E> GraphPath<V, E> findPathBetween(Graph<V, E> graph, V source2, V sink2) {
        return new DijkstraShortestPath<V, E>(graph).getPath(source2, sink2);
    }

    @Override
    public GraphPath<V, E> getPath(V source2, V sink2) {
        V vertex;
        if (!this.graph.containsVertex(source2)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        if (!this.graph.containsVertex(sink2)) {
            throw new IllegalArgumentException("Graph must contain the sink vertex!");
        }
        if (source2.equals(sink2)) {
            return this.createEmptyPath(source2, sink2);
        }
        DijkstraClosestFirstIterator<V, E> it = new DijkstraClosestFirstIterator<V, E>(this.graph, source2, this.radius, this.heapSupplier);
        while (it.hasNext() && !(vertex = it.next()).equals(sink2)) {
        }
        return it.getPaths().getPath(sink2);
    }

    @Override
    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths(V source2) {
        if (!this.graph.containsVertex(source2)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        DijkstraClosestFirstIterator<V, E> it = new DijkstraClosestFirstIterator<V, E>(this.graph, source2, this.radius, this.heapSupplier);
        while (it.hasNext()) {
            it.next();
        }
        return it.getPaths();
    }
}

