/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.MatrixStrategy;
import org.apfloat.spi.Util;

public class LongMatrixStrategy
implements MatrixStrategy {
    @Override
    public void transpose(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        long[] data2 = arrayAccess.getLongData();
        int offset = arrayAccess.getOffset();
        if (n1 != (n1 & -n1) || n2 != (n2 & -n2) || n1 <= 0 || n2 <= 0) {
            throw new ApfloatInternalException("Matrix size must be a power of two, not " + n1 + " x " + n2);
        }
        if (n1 == n2) {
            LongMatrixStrategy.transposeSquare(data2, offset, n1, n1);
        } else if (n2 == 2 * n1) {
            LongMatrixStrategy.transposeSquare(data2, offset, n1, n2);
            LongMatrixStrategy.transposeSquare(data2, offset + n1, n1, n2);
            LongMatrixStrategy.permuteToHalfWidth(data2, offset, n1, n2);
        } else if (n1 == 2 * n2) {
            LongMatrixStrategy.permuteToDoubleWidth(data2, offset, n1, n2);
            LongMatrixStrategy.transposeSquare(data2, offset, n2, n1);
            LongMatrixStrategy.transposeSquare(data2, offset + n2, n2, n1);
        } else {
            throw new ApfloatInternalException("Must be n1 = n2, n1 = 2*n2 or n2 = 2*n1; matrix is " + n1 + " x " + n2);
        }
    }

    @Override
    public void transposeSquare(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        LongMatrixStrategy.transposeSquare(arrayAccess.getLongData(), arrayAccess.getOffset(), n1, n2);
    }

    @Override
    public void permuteToDoubleWidth(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        if (n1 != (n1 & -n1) || n2 != (n2 & -n2) || n1 <= 0 || n2 <= 0) {
            throw new ApfloatInternalException("Matrix size must be a power of two, not " + n1 + " x " + n2);
        }
        if (n1 < 2) {
            throw new ApfloatInternalException("Matrix height must be at least 2.");
        }
        LongMatrixStrategy.permuteToDoubleWidth(arrayAccess.getLongData(), arrayAccess.getOffset(), n1, n2);
    }

    @Override
    public void permuteToHalfWidth(ArrayAccess arrayAccess, int n1, int n2) throws ApfloatRuntimeException {
        if (n1 != (n1 & -n1) || n2 != (n2 & -n2) || n1 <= 0 || n2 <= 0) {
            throw new ApfloatInternalException("Matrix size must be a power of two, not " + n1 + " x " + n2);
        }
        LongMatrixStrategy.permuteToHalfWidth(arrayAccess.getLongData(), arrayAccess.getOffset(), n1, n2);
    }

    private static void moveBlock(long[] source2, int sourceOffset, int sourceWidth, long[] dest, int destOffset, int destWidth, int b) {
        for (int i = 0; i < b; ++i) {
            System.arraycopy(source2, sourceOffset, dest, destOffset, b);
            destOffset += destWidth;
            sourceOffset += sourceWidth;
        }
    }

    private static void transpose2blocks(long[] data2, int offset1, int offset2, int width, int b) {
        int i = 0;
        int position1 = offset2;
        while (i < b) {
            int j = 0;
            int position2 = offset1 + i;
            while (j < b) {
                long tmp = data2[position1 + j];
                data2[position1 + j] = data2[position2];
                data2[position2] = tmp;
                ++j;
                position2 += width;
            }
            ++i;
            position1 += width;
        }
    }

    private static void transposeBlock(long[] data2, int offset, int width, int b) {
        int i = 0;
        int position1 = offset;
        while (i < b) {
            int j = i + 1;
            int position2 = offset + j * width + i;
            while (j < b) {
                long tmp = data2[position1 + j];
                data2[position1 + j] = data2[position2];
                data2[position2] = tmp;
                ++j;
                position2 += width;
            }
            ++i;
            position1 += width;
        }
    }

    private static void transposeSquare(long[] data2, int offset, int n1, int n2) {
        ApfloatContext ctx = ApfloatContext.getContext();
        int cacheBurstBlockSize = Util.round2down(ctx.getCacheBurst() / 8);
        int cacheBlockSize = Util.sqrt4down(ctx.getCacheL1Size() / 8);
        int cacheThreshold = Util.round2down(ctx.getCacheL2Size() / 8);
        if (n1 <= cacheBurstBlockSize || n1 <= cacheBlockSize) {
            LongMatrixStrategy.transposeBlock(data2, offset, n2, n1);
        } else if (n1 * n2 <= cacheThreshold) {
            int b = cacheBurstBlockSize;
            int i = 0;
            int position1 = offset;
            while (i < n1) {
                LongMatrixStrategy.transposeBlock(data2, position1 + i, n2, b);
                int j = i + b;
                int position2 = offset + j * n2 + i;
                while (j < n1) {
                    LongMatrixStrategy.transpose2blocks(data2, position1 + j, position2, n2, b);
                    j += b;
                    position2 += b * n2;
                }
                i += b;
                position1 += b * n2;
            }
        } else {
            int b = cacheBlockSize;
            long[] tmp1 = new long[b * b];
            long[] tmp2 = new long[b * b];
            int i = 0;
            int position1 = offset;
            while (i < n1) {
                LongMatrixStrategy.moveBlock(data2, position1 + i, n2, tmp1, 0, b, b);
                LongMatrixStrategy.transposeBlock(tmp1, 0, b, b);
                LongMatrixStrategy.moveBlock(tmp1, 0, b, data2, position1 + i, n2, b);
                int j = i + b;
                int position2 = offset + j * n2 + i;
                while (j < n1) {
                    LongMatrixStrategy.moveBlock(data2, position1 + j, n2, tmp1, 0, b, b);
                    LongMatrixStrategy.transposeBlock(tmp1, 0, b, b);
                    LongMatrixStrategy.moveBlock(data2, position2, n2, tmp2, 0, b, b);
                    LongMatrixStrategy.transposeBlock(tmp2, 0, b, b);
                    LongMatrixStrategy.moveBlock(tmp2, 0, b, data2, position1 + j, n2, b);
                    LongMatrixStrategy.moveBlock(tmp1, 0, b, data2, position2, n2, b);
                    j += b;
                    position2 += b * n2;
                }
                i += b;
                position1 += b * n2;
            }
        }
    }

    private static void permuteToHalfWidth(long[] data2, int offset, int n1, int n2) {
        if (n1 < 2) {
            return;
        }
        int twicen1 = 2 * n1;
        int halfn2 = n2 / 2;
        long[] tmp = new long[halfn2];
        boolean[] isRowDone = new boolean[twicen1];
        int j = 1;
        do {
            int o = j;
            int m4 = j;
            System.arraycopy(data2, offset + halfn2 * m4, tmp, 0, halfn2);
            isRowDone[m4] = true;
            int n = m4 = m4 < n1 ? 2 * m4 : 2 * (m4 - n1) + 1;
            while (m4 != j) {
                isRowDone[m4] = true;
                System.arraycopy(data2, offset + halfn2 * m4, data2, offset + halfn2 * o, halfn2);
                o = m4;
                m4 = m4 < n1 ? 2 * m4 : 2 * (m4 - n1) + 1;
            }
            System.arraycopy(tmp, 0, data2, offset + halfn2 * o, halfn2);
            while (isRowDone[j]) {
                ++j;
            }
        } while (j < twicen1 - 1);
    }

    private static void permuteToDoubleWidth(long[] data2, int offset, int n1, int n2) {
        if (n1 < 4) {
            return;
        }
        int halfn1 = n1 / 2;
        long[] tmp = new long[n2];
        boolean[] isRowDone = new boolean[n1];
        int j = 1;
        do {
            int o = j;
            int m4 = j;
            System.arraycopy(data2, offset + n2 * m4, tmp, 0, n2);
            isRowDone[m4] = true;
            int n = m4 = (m4 & 1) != 0 ? m4 / 2 + halfn1 : m4 / 2;
            while (m4 != j) {
                isRowDone[m4] = true;
                System.arraycopy(data2, offset + n2 * m4, data2, offset + n2 * o, n2);
                o = m4;
                m4 = (m4 & 1) != 0 ? m4 / 2 + halfn1 : m4 / 2;
            }
            System.arraycopy(tmp, 0, data2, offset + n2 * o, n2);
            while (isRowDone[j]) {
                ++j;
            }
        } while (j < n1 - 1);
    }
}

