/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.jvm.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.metadata.InconsistentKotlinMetadataException;
import kotlinx.metadata.KmAnnotation;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmLambda;
import kotlinx.metadata.KmPackage;
import kotlinx.metadata.internal.ReadersKt;
import kotlinx.metadata.internal.metadata.ProtoBuf;
import kotlinx.metadata.internal.metadata.jvm.deserialization.JvmNameResolver;
import kotlinx.metadata.internal.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlinx.metadata.internal.metadata.jvm.deserialization.ModuleMapping;
import kotlinx.metadata.internal.metadata.jvm.deserialization.PackageParts;
import kotlinx.metadata.jvm.JvmMetadataVersion;
import kotlinx.metadata.jvm.KmModule;
import kotlinx.metadata.jvm.KmPackageParts;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import kotlinx.metadata.jvm.UnstableMetadataApi;
import kotlinx.metadata.jvm.internal.JvmExceptionUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001e\u00a8\u0006\u001f"}, d2={"Lkotlinx/metadata/jvm/internal/JvmReadUtils;", "", "()V", "checkMetadataVersionForRead", "", "annotationData", "Lkotlin/Metadata;", "lenient", "", "isLessThan14", "readKmClass", "Lkotlinx/metadata/KmClass;", "readKmClass$kotlinx_metadata_jvm", "readKmLambda", "Lkotlinx/metadata/KmLambda;", "readKmLambda$kotlinx_metadata_jvm", "readKmPackage", "Lkotlinx/metadata/KmPackage;", "readKmPackage$kotlinx_metadata_jvm", "readMetadataImpl", "Lkotlinx/metadata/jvm/KotlinClassMetadata;", "readMetadataImpl$kotlinx_metadata_jvm", "readModuleMetadataImpl", "Lkotlinx/metadata/jvm/KmModule;", "data", "Lkotlinx/metadata/internal/metadata/jvm/deserialization/ModuleMapping;", "readModuleMetadataImpl$kotlinx_metadata_jvm", "throwIfNotCompatible", "jvmMetadataVersion", "Lkotlinx/metadata/internal/metadata/jvm/deserialization/JvmMetadataVersion;", "throwIfNotCompatible$kotlinx_metadata_jvm", "kotlinx-metadata-jvm"})
@SourceDebugExtension(value={"SMAP\nJvmReadUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmReadUtils.kt\nkotlinx/metadata/jvm/internal/JvmReadUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JvmExceptionUtils.kt\nkotlinx/metadata/jvm/internal/JvmExceptionUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n15#3,8:107\n3183#4,10:115\n1269#4,2:125\n1283#4,4:127\n*S KotlinDebug\n*F\n+ 1 JvmReadUtils.kt\nkotlinx/metadata/jvm/internal/JvmReadUtils\n*L\n49#1:107,8\n65#1:115,10\n68#1:125,2\n68#1:127,4\n*E\n"})
public final class JvmReadUtils {
    @NotNull
    public static final JvmReadUtils INSTANCE = new JvmReadUtils();

    private JvmReadUtils() {
    }

    private final boolean isLessThan14(Metadata annotationData) {
        return new JvmMetadataVersion(annotationData.mv()).compareTo(new JvmMetadataVersion(1, 4, 0)) < 0;
    }

    @NotNull
    public final KmClass readKmClass$kotlinx_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter(annotationData, "annotationData");
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = pair.component1();
        ProtoBuf.Class proto = pair.component2();
        return ReadersKt.toKmClass$default(proto, strings, this.isLessThan14(annotationData), null, 4, null);
    }

    @NotNull
    public final KmPackage readKmPackage$kotlinx_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter(annotationData, "annotationData");
        Pair<JvmNameResolver, ProtoBuf.Package> pair = JvmProtoBufUtil.readPackageDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = pair.component1();
        ProtoBuf.Package proto = pair.component2();
        return ReadersKt.toKmPackage$default(proto, strings, this.isLessThan14(annotationData), null, 4, null);
    }

    @Nullable
    public final KmLambda readKmLambda$kotlinx_metadata_jvm(@NotNull Metadata annotationData) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(annotationData, "annotationData");
                String[] stringArray = annotationData.d1();
                Object[] p0 = stringArray;
                boolean bl = false;
                object = !(p0.length == 0) ? stringArray : null;
                if (object == null) break block2;
                String[] data1 = object;
                boolean bl2 = false;
                Pair<JvmNameResolver, ProtoBuf.Function> pair = JvmProtoBufUtil.readFunctionDataFrom(data1, annotationData.d2());
                object = pair;
                if (pair != null) break block3;
            }
            return null;
        }
        Object functionData = object;
        JvmNameResolver strings = (JvmNameResolver)((Pair)functionData).component1();
        ProtoBuf.Function proto = (ProtoBuf.Function)((Pair)functionData).component2();
        return ReadersKt.toKmLambda(proto, strings, this.isLessThan14(annotationData));
    }

    @NotNull
    public final KotlinClassMetadata readMetadataImpl$kotlinx_metadata_jvm(@NotNull Metadata annotationData, boolean lenient) {
        KotlinClassMetadata kotlinClassMetadata;
        Intrinsics.checkNotNullParameter(annotationData, "annotationData");
        this.checkMetadataVersionForRead(annotationData, lenient);
        boolean $i$f$wrapIntoMetadataExceptionWhenNeeded = false;
        try {
            KotlinClassMetadata kotlinClassMetadata2;
            boolean bl = false;
            switch (annotationData.k()) {
                case 1: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Class(annotationData, lenient);
                    break;
                }
                case 2: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.FileFacade(annotationData, lenient);
                    break;
                }
                case 3: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.SyntheticClass(annotationData, lenient);
                    break;
                }
                case 4: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassFacade(annotationData, lenient);
                    break;
                }
                case 5: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassPart(annotationData, lenient);
                    break;
                }
                default: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Unknown(annotationData, lenient);
                }
            }
            kotlinClassMetadata = kotlinClassMetadata2;
        }
        catch (Throwable e$iv) {
            Throwable throwable = e$iv;
            throw throwable instanceof IllegalArgumentException ? e$iv : ((throwable instanceof VirtualMachineError ? true : throwable instanceof ThreadDeath) ? e$iv : (Throwable)new InconsistentKotlinMetadataException("Exception occurred when reading Kotlin metadata", e$iv));
        }
        return kotlinClassMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @UnstableMetadataApi
    @NotNull
    public final KmModule readModuleMetadataImpl$kotlinx_metadata_jvm(@NotNull ModuleMapping data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        KmModule v = new KmModule();
        for (Map.Entry<String, PackageParts> entry : data2.getPackageFqName2Parts().entrySet()) {
            void $this$associateWith$iv;
            String fqName2 = entry.getKey();
            PackageParts parts = entry.getValue();
            Iterable $this$partition$iv = parts.getParts();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (parts.getMultifileFacadeName(it) == null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List fileFacades = pair.component1();
            List multiFileClassParts = pair.component2();
            Map<String, KmPackageParts> map = v.getPackageParts();
            second$iv = multiFileClassParts;
            List<String> list = CollectionsKt.toMutableList(fileFacades);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string;
                void it;
                String string2 = (String)element$iv$iv;
                Object t2 = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(parts.getMultifileFacadeName((String)it));
                map2.put(t2, string);
            }
            Map<String, String> map3 = MapsKt.toMutableMap(result$iv);
            List<String> list2 = list;
            KmPackageParts kmPackageParts = new KmPackageParts(list2, map3);
            map.put(fqName2, kmPackageParts);
        }
        for (String annotation : data2.getModuleData().getAnnotations()) {
            v.getAnnotations().add(new KmAnnotation(annotation, MapsKt.emptyMap()));
        }
        for (ProtoBuf.Class classProto : data2.getModuleData().getOptionalAnnotations()) {
            v.getOptionalAnnotationClasses().add(ReadersKt.toKmClass$default(classProto, data2.getModuleData().getNameResolver(), false, null, 4, null));
        }
        return v;
    }

    private final void checkMetadataVersionForRead(Metadata annotationData, boolean lenient) {
        if (annotationData.mv().length == 0) {
            throw new IllegalArgumentException("Provided Metadata instance does not have metadataVersion in it and therefore is malformed and cannot be read.");
        }
        kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion jvmMetadataVersion = new kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion(annotationData.mv(), (annotationData.xi() & 8) != 0);
        this.throwIfNotCompatible$kotlinx_metadata_jvm(jvmMetadataVersion, lenient);
    }

    public final void throwIfNotCompatible$kotlinx_metadata_jvm(@NotNull kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion jvmMetadataVersion, boolean lenient) {
        boolean isCompatible;
        Intrinsics.checkNotNullParameter(jvmMetadataVersion, "jvmMetadataVersion");
        boolean isAtLeast110 = jvmMetadataVersion.isAtLeast(1, 1, 0);
        boolean bl = isCompatible = lenient ? isAtLeast110 : jvmMetadataVersion.isCompatibleWithCurrentCompilerVersion();
        if (!isCompatible) {
            String postfix = !isAtLeast110 ? "while minimum supported version is 1.1.0 (Kotlin 1.0)." : "while maximum supported version is " + (jvmMetadataVersion.isStrictSemantics() ? kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion.INSTANCE : kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion.INSTANCE_NEXT) + ". To support newer versions, update the kotlinx-metadata-jvm library.";
            throw new IllegalArgumentException("Provided Metadata instance has version " + jvmMetadataVersion + ", " + postfix);
        }
    }
}

