/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.hierarchy.ClassHierarchy;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.problems.FieldNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.IllegalFieldAccessProblem;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.hierarchy.ClassHierarchyBuilder;
import com.jetbrains.pluginverifier.verifiers.resolution.AccessibilityUtilKt;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u0013\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver;", "", "()V", "checkFieldIsAccessible", "", "field", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "fieldReference", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "callerMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "doResolveField", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult;", "classFile", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "registerFieldNotFoundProblem", "resolveField", "FieldResolutionResult", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nFieldResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldResolver.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,129:1\n179#2,2:130\n*S KotlinDebug\n*F\n+ 1 FieldResolver.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver\n*L\n55#1:130,2\n*E\n"})
public final class FieldResolver {
    @Nullable
    public final Field resolveField(@NotNull ClassFile classFile, @NotNull FieldReference fieldReference, @NotNull VerificationContext context, @NotNull Method callerMethod, @NotNull Instruction instruction) {
        Field field;
        Intrinsics.checkNotNullParameter(classFile, "classFile");
        Intrinsics.checkNotNullParameter(fieldReference, "fieldReference");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        FieldResolutionResult resolutionResult = this.doResolveField(classFile, fieldReference, context);
        if (Intrinsics.areEqual(resolutionResult, FieldResolutionResult.Abort.INSTANCE)) {
            field = null;
        } else if (Intrinsics.areEqual(resolutionResult, FieldResolutionResult.NotFound.INSTANCE)) {
            this.registerFieldNotFoundProblem(context, fieldReference, instruction, callerMethod, classFile);
            field = null;
        } else if (resolutionResult instanceof FieldResolutionResult.Found) {
            this.checkFieldIsAccessible(((FieldResolutionResult.Found)resolutionResult).getField(), fieldReference, callerMethod, instruction, context);
            field = ((FieldResolutionResult.Found)resolutionResult).getField();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return field;
    }

    private final FieldResolutionResult doResolveField(ClassFile classFile, FieldReference fieldReference, VerificationContext context) {
        Field field;
        block10: {
            Sequence<Field> $this$firstOrNull$iv = classFile.getFields();
            boolean $i$f$firstOrNull = false;
            Iterator<Field> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Field element$iv;
                Field it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), fieldReference.getFieldName()) && Intrinsics.areEqual(it.getDescriptor(), fieldReference.getFieldDescriptor()))) continue;
                field = element$iv;
                break block10;
            }
            field = null;
        }
        Field matchingField = field;
        if (matchingField != null) {
            return new FieldResolutionResult.Found(matchingField);
        }
        for (String anInterface : classFile.getInterfaces()) {
            ClassFile resolvedInterface;
            if (ResolutionUtilKt.resolveClassChecked$default(context.getClassResolver(), anInterface, classFile, context, null, 8, null) == null) {
                return FieldResolutionResult.Abort.INSTANCE;
            }
            FieldResolutionResult lookupResult = this.doResolveField(resolvedInterface, fieldReference, context);
            if (Intrinsics.areEqual(lookupResult, FieldResolutionResult.NotFound.INSTANCE)) continue;
            if (Intrinsics.areEqual(lookupResult, FieldResolutionResult.Abort.INSTANCE)) {
                return lookupResult;
            }
            if (!(lookupResult instanceof FieldResolutionResult.Found)) continue;
            return lookupResult;
        }
        String superName = classFile.getSuperName();
        if (superName != null) {
            ClassFile classFile2 = ResolutionUtilKt.resolveClassChecked$default(context.getClassResolver(), superName, classFile, context, null, 8, null);
            if (classFile2 == null) {
                return FieldResolutionResult.Abort.INSTANCE;
            }
            ClassFile resolvedSuper = classFile2;
            FieldResolutionResult lookupResult = this.doResolveField(resolvedSuper, fieldReference, context);
            if (!Intrinsics.areEqual(lookupResult, FieldResolutionResult.NotFound.INSTANCE)) {
                if (Intrinsics.areEqual(lookupResult, FieldResolutionResult.Abort.INSTANCE)) {
                    return lookupResult;
                }
                if (lookupResult instanceof FieldResolutionResult.Found) {
                    return lookupResult;
                }
            }
        }
        return FieldResolutionResult.NotFound.INSTANCE;
    }

    private final void registerFieldNotFoundProblem(VerificationContext context, FieldReference fieldReference, Instruction instruction, Method callerMethod, ClassFile classFile) {
        ClassHierarchy classHierarchy = new ClassHierarchyBuilder(context).buildClassHierarchy(classFile);
        context.getProblemRegistrar().registerProblem(new FieldNotFoundProblem(fieldReference, callerMethod.getLocation(), classHierarchy, instruction));
    }

    private final void checkFieldIsAccessible(Field field, FieldReference fieldReference, Method callerMethod, Instruction instruction, VerificationContext context) {
        AccessType accessProblem = AccessibilityUtilKt.detectAccessProblem(field, callerMethod, context);
        if (accessProblem != null) {
            context.getProblemRegistrar().registerProblem(new IllegalFieldAccessProblem(fieldReference, field.getLocation(), callerMethod.getLocation(), instruction, accessProblem));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult;", "", "()V", "Abort", "Found", "NotFound", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult$Abort;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult$Found;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult$NotFound;", "verifier-core"})
    private static abstract class FieldResolutionResult {
        private FieldResolutionResult() {
        }

        public /* synthetic */ FieldResolutionResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult$Abort;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult;", "()V", "verifier-core"})
        public static final class Abort
        extends FieldResolutionResult {
            @NotNull
            public static final Abort INSTANCE = new Abort();

            private Abort() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult$Found;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult;", "field", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "(Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;)V", "getField", "()Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "verifier-core"})
        public static final class Found
        extends FieldResolutionResult {
            @NotNull
            private final Field field;

            public Found(@NotNull Field field) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(null);
                this.field = field;
            }

            @NotNull
            public final Field getField() {
                return this.field;
            }

            @NotNull
            public final Field component1() {
                return this.field;
            }

            @NotNull
            public final Found copy(@NotNull Field field) {
                Intrinsics.checkNotNullParameter(field, "field");
                return new Found(field);
            }

            public static /* synthetic */ Found copy$default(Found found, Field field, int n, Object object) {
                if ((n & 1) != 0) {
                    field = found.field;
                }
                return found.copy(field);
            }

            @NotNull
            public String toString() {
                return "Found(field=" + this.field + ")";
            }

            public int hashCode() {
                return this.field.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Found)) {
                    return false;
                }
                Found found = (Found)other;
                return Intrinsics.areEqual(this.field, found.field);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult$NotFound;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FieldResolver$FieldResolutionResult;", "()V", "verifier-core"})
        public static final class NotFound
        extends FieldResolutionResult {
            @NotNull
            public static final NotFound INSTANCE = new NotFound();

            private NotFound() {
                super(null);
            }
        }
    }
}

