/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.instruction;

import com.jetbrains.pluginverifier.verifiers.BytecodeUtilKt;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.instruction.InstructionVerifier;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/instruction/LdcInstructionVerifier;", "Lcom/jetbrains/pluginverifier/verifiers/instruction/InstructionVerifier;", "()V", "checkTypeExists", "", "type", "Lorg/objectweb/asm/Type;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "method", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "verify", "instructionNode", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "verifier-core"})
public final class LdcInstructionVerifier
implements InstructionVerifier {
    @Override
    public void verify(@NotNull Method method, @NotNull AbstractInsnNode instructionNode, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instructionNode, "instructionNode");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(instructionNode instanceof LdcInsnNode)) {
            return;
        }
        Object object = ((LdcInsnNode)instructionNode).cst;
        Type type2 = object instanceof Type ? (Type)object : null;
        if (type2 == null) {
            return;
        }
        Type type3 = type2;
        if (type3.getSort() == 10) {
            this.checkTypeExists(type3, context, method);
        } else if (type3.getSort() == 11) {
            Type[] typeArray = type3.getArgumentTypes();
            Intrinsics.checkNotNullExpressionValue(typeArray, "type.argumentTypes");
            for (Type argumentType : typeArray) {
                Intrinsics.checkNotNullExpressionValue(argumentType, "argumentType");
                this.checkTypeExists(argumentType, context, method);
            }
            Type type4 = type3.getReturnType();
            Intrinsics.checkNotNullExpressionValue(type4, "type.returnType");
            this.checkTypeExists(type4, context, method);
        }
    }

    private final void checkTypeExists(Type type2, VerificationContext context, Method method) {
        String string = type2.getDescriptor();
        Intrinsics.checkNotNullExpressionValue(string, "type.descriptor");
        String string2 = BytecodeUtilKt.extractClassNameFromDescriptor(string);
        if (string2 == null) {
            return;
        }
        String className = string2;
        ResolutionUtilKt.resolveClassChecked$default(context.getClassResolver(), className, method, context, null, 8, null);
    }
}

