/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.hierarchy;

import com.jetbrains.pluginverifier.verifiers.hierarchy.ClassParentsVisitor;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00128\u0010\u0004\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\fJ@\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00032\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u00152\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0015R@\u0010\u0004\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000ej\b\u0012\u0004\u0012\u00020\n`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/hierarchy/ClassParentsVisitor;", "", "visitInterfaces", "", "parentResolver", "Lkotlin/Function2;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "Lkotlin/ParameterName;", "name", "subclassFile", "", "parentClassName", "(ZLkotlin/jvm/functions/Function2;)V", "visitedClasses", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "visitClass", "", "currentClass", "visitSelf", "onEnter", "Lkotlin/Function1;", "onExit", "verifier-core"})
public final class ClassParentsVisitor {
    private final boolean visitInterfaces;
    @NotNull
    private final Function2<ClassFile, String, ClassFile> parentResolver;
    @NotNull
    private final HashSet<String> visitedClasses;

    public ClassParentsVisitor(boolean visitInterfaces, @NotNull Function2<? super ClassFile, ? super String, ? extends ClassFile> parentResolver) {
        Intrinsics.checkNotNullParameter(parentResolver, "parentResolver");
        this.visitInterfaces = visitInterfaces;
        this.parentResolver = parentResolver;
        this.visitedClasses = new HashSet();
    }

    public final void visitClass(@NotNull ClassFile currentClass, boolean visitSelf, @NotNull Function1<? super ClassFile, Boolean> onEnter, @NotNull Function1<? super ClassFile, Unit> onExit) {
        Intrinsics.checkNotNullParameter(currentClass, "currentClass");
        Intrinsics.checkNotNullParameter(onEnter, "onEnter");
        Intrinsics.checkNotNullParameter(onExit, "onExit");
        this.visitedClasses.add(currentClass.getName());
        if (visitSelf && !onEnter.invoke(currentClass).booleanValue()) {
            return;
        }
        List<Object> interfaces = this.visitInterfaces ? currentClass.getInterfaces() : CollectionsKt.emptyList();
        List<String> superParents = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(currentClass.getSuperName()), (Iterable)interfaces);
        for (String superParent : superParents) {
            ClassFile superNode;
            if (this.visitedClasses.contains(superParent) || (superNode = this.parentResolver.invoke(currentClass, superParent)) == null) continue;
            this.visitClass(superNode, true, onEnter, onExit);
        }
        if (visitSelf) {
            onExit.invoke(currentClass);
        }
    }

    public static /* synthetic */ void visitClass$default(ClassParentsVisitor classParentsVisitor, ClassFile classFile, boolean bl, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 8) != 0) {
            function12 = visitClass.1.INSTANCE;
        }
        classParentsVisitor.visitClass(classFile, bl, function1, function12);
    }
}

