/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers;

import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodAsm;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u001c\u0010\u0000\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"analyzeMethodFrames", "", "Lorg/objectweb/asm/tree/analysis/Frame;", "Lorg/objectweb/asm/tree/analysis/SourceValue;", "method", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "getOnStack", "index", "", "verifier-core"})
public final class CodeAnalysisUtilKt {
    @Nullable
    public static final List<Frame<SourceValue>> analyzeMethodFrames(@NotNull Method method) {
        List<Object> list;
        Intrinsics.checkNotNullParameter(method, "method");
        if (method instanceof MethodAsm) {
            Frame<V>[] frameArray = new Analyzer(new SourceInterpreter()).analyze(method.getContainingClassFile().getName(), ((MethodAsm)method).getAsmNode());
            Intrinsics.checkNotNullExpressionValue(frameArray, "Analyzer(SourceInterpret\u2026ile.name, method.asmNode)");
            list = ArraysKt.toList((Object[])frameArray);
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final SourceValue getOnStack(@NotNull Frame<SourceValue> $this$getOnStack, int index) {
        Intrinsics.checkNotNullParameter($this$getOnStack, "<this>");
        return $this$getOnStack.getStack($this$getOnStack.getStackSize() - 1 - index);
    }
}

