/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.discouraging;

import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.location.LocationToReferenceKt;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.usages.UsageLocationPresentationKt;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecatedApiUsage;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecationInfo;
import com.jetbrains.pluginverifier.usages.discouraging.DiscouragingJdkClassUsage$_get_fullDescription_$lambda$0$;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/pluginverifier/usages/discouraging/DiscouragingJdkClassUsage;", "Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecatedApiUsage;", "apiElement", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "classFileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "(Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Lcom/jetbrains/pluginverifier/results/location/Location;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;)V", "getApiElement", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "apiReference", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "getApiReference", "()Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUsageLocation", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDiscouragingJdkClassUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscouragingJdkClassUsage.kt\ncom/jetbrains/pluginverifier/usages/discouraging/DiscouragingJdkClassUsage\n+ 2 FileOrigin.kt\ncom/jetbrains/plugin/structure/classes/resolvers/FileOriginKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,68:1\n16#2:69\n14#2:70\n473#3:71\n*S KotlinDebug\n*F\n+ 1 DiscouragingJdkClassUsage.kt\ncom/jetbrains/pluginverifier/usages/discouraging/DiscouragingJdkClassUsage\n*L\n47#1:69\n47#1:70\n47#1:71\n*E\n"})
public final class DiscouragingJdkClassUsage
extends DeprecatedApiUsage {
    @NotNull
    private final ClassLocation apiElement;
    @NotNull
    private final Location usageLocation;
    @NotNull
    private final FileOrigin classFileOrigin;

    public DiscouragingJdkClassUsage(@NotNull ClassLocation apiElement, @NotNull Location usageLocation, @NotNull FileOrigin classFileOrigin) {
        Intrinsics.checkNotNullParameter(apiElement, "apiElement");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        Intrinsics.checkNotNullParameter(classFileOrigin, "classFileOrigin");
        super(new DeprecationInfo(false, "JDK 8"));
        this.apiElement = apiElement;
        this.usageLocation = usageLocation;
        this.classFileOrigin = classFileOrigin;
    }

    @Override
    @NotNull
    public ClassLocation getApiElement() {
        return this.apiElement;
    }

    @Override
    @NotNull
    public Location getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "JDK classes of some packages should not be used when they come from JDK or IDEA distribution because these classes will not be available in JDK 9+.";
    }

    @Override
    @NotNull
    public ClassReference getApiReference() {
        return LocationToReferenceKt.toReference(this.getApiElement());
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Usage of JDK 8 specific " + this.getApiElement().getElementType().getPresentableName() + " " + LocationsPresentationKt.formatClassLocation(this.getApiElement(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_fullDescription__u24lambda_u240.append("JDK 8 specific " + this.getApiElement().getElementType().getPresentableName() + " " + LocationsPresentationKt.formatClassLocation(this.getApiElement(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS));
        $this$_get_fullDescription__u24lambda_u240.append(" is referenced in " + UsageLocationPresentationKt.formatUsageLocation(this.getUsageLocation()) + ". ");
        FileOrigin $this$isOriginOfType$iv = this.classFileOrigin;
        boolean $i$f$isOriginOfType = false;
        FileOrigin $this$findOriginOfType$iv$iv = $this$isOriginOfType$iv;
        boolean $i$f$findOriginOfType = false;
        Sequence<FileOrigin> $this$filterIsInstance$iv$iv$iv = SequencesKt.generateSequence($this$findOriginOfType$iv$iv, (Function1)_get_fullDescription_$lambda$0$$inlined$isOriginOfType$1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence<FileOrigin> sequence2 = SequencesKt.filter($this$filterIsInstance$iv$iv$iv, _get_fullDescription_$lambda$0$$inlined$isOriginOfType$2.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        boolean bl2 = SequencesKt.firstOrNull(sequence2) != null;
        boolean isClassProvidedByIde = bl2;
        if (isClassProvidedByIde) {
            $this$_get_fullDescription__u24lambda_u240.append("This " + this.getApiElement().getElementType().getPresentableName() + " will be temporarily available in IDE distribution for compatibility but you should use another API or provide your own dependency containing the classes.");
        } else {
            $this$_get_fullDescription__u24lambda_u240.append("This " + this.getApiElement().getElementType().getPresentableName() + " is neither available in JDK 9+ nor is it available in IDE distribution. This may lead to compatibility problems when running the IDE with newer JDK versions.");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof DiscouragingJdkClassUsage && Intrinsics.areEqual(this.getApiElement(), ((DiscouragingJdkClassUsage)other).getApiElement()) && Intrinsics.areEqual(this.getUsageLocation(), ((DiscouragingJdkClassUsage)other).getUsageLocation()) && Intrinsics.areEqual(this.classFileOrigin, ((DiscouragingJdkClassUsage)other).classFileOrigin);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getApiElement(), this.getUsageLocation(), this.classFileOrigin};
        return Objects.hash(objectArray);
    }
}

