/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.tasks.processAllPlugins;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.caches.PluginResourceCache;
import com.jetbrains.pluginverifier.ide.IdeDescriptor;
import com.jetbrains.pluginverifier.misc.RetryUtilKt;
import com.jetbrains.pluginverifier.options.CmdOpts;
import com.jetbrains.pluginverifier.options.OptionsParser;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.local.LocalPluginRepositoryFactory;
import com.jetbrains.pluginverifier.tasks.CommandRunner;
import com.jetbrains.pluginverifier.tasks.TaskParameters;
import com.jetbrains.pluginverifier.tasks.TaskParametersBuilder;
import com.jetbrains.pluginverifier.tasks.processAllPlugins.CountUsagesOfExtensionPointsParameters;
import java.io.Closeable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J.\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/tasks/processAllPlugins/ProcessAllPluginsCommand;", "Lcom/jetbrains/pluginverifier/tasks/CommandRunner;", "()V", "commandName", "", "getCommandName", "()Ljava/lang/String;", "getParametersBuilder", "Lcom/jetbrains/pluginverifier/tasks/TaskParametersBuilder;", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "pluginDetailsCache", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "extractedPluginCache", "Lcom/jetbrains/plugin/structure/intellij/plugin/caches/PluginResourceCache;", "reportage", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "parseCountUsagesOfExtensionPointsParameters", "Lcom/jetbrains/pluginverifier/tasks/TaskParameters;", "freeArgs", "", "opts", "Lcom/jetbrains/pluginverifier/options/CmdOpts;", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nProcessAllPluginsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessAllPluginsCommand.kt\ncom/jetbrains/pluginverifier/tasks/processAllPlugins/ProcessAllPluginsCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n1#1,86:1\n1#2:87\n70#3,5:88\n*S KotlinDebug\n*F\n+ 1 ProcessAllPluginsCommand.kt\ncom/jetbrains/pluginverifier/tasks/processAllPlugins/ProcessAllPluginsCommand\n*L\n59#1:88,5\n*E\n"})
public final class ProcessAllPluginsCommand
implements CommandRunner {
    @Override
    @NotNull
    public String getCommandName() {
        return "processAllPlugins";
    }

    @Override
    @NotNull
    public TaskParametersBuilder getParametersBuilder(@NotNull PluginRepository pluginRepository, @NotNull PluginDetailsCache pluginDetailsCache, @NotNull PluginResourceCache extractedPluginCache, @NotNull PluginVerificationReportage reportage) {
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        Intrinsics.checkNotNullParameter(pluginDetailsCache, "pluginDetailsCache");
        Intrinsics.checkNotNullParameter(extractedPluginCache, "extractedPluginCache");
        Intrinsics.checkNotNullParameter(reportage, "reportage");
        return new TaskParametersBuilder(this, reportage, pluginRepository){
            final /* synthetic */ ProcessAllPluginsCommand this$0;
            final /* synthetic */ PluginVerificationReportage $reportage;
            final /* synthetic */ PluginRepository $pluginRepository;
            {
                this.this$0 = $receiver;
                this.$reportage = $reportage;
                this.$pluginRepository = $pluginRepository;
            }

            @NotNull
            public TaskParameters build(@NotNull CmdOpts opts, @NotNull List<String> freeArgs) {
                Intrinsics.checkNotNullParameter(opts, "opts");
                Intrinsics.checkNotNullParameter(freeArgs, "freeArgs");
                if (!(!((Collection)freeArgs).isEmpty())) {
                    boolean bl = false;
                    String string = "Usage: java -jar verifier.jar processAllPlugins [goal name] <goal parameters (optional)>";
                    throw new IllegalArgumentException(string.toString());
                }
                String goalName = freeArgs.get(0);
                if (!Intrinsics.areEqual(goalName, "countUsagesOfExtensionPoints")) {
                    throw new IllegalStateException(("Unknown goal '" + goalName + "'").toString());
                }
                return ProcessAllPluginsCommand.access$parseCountUsagesOfExtensionPointsParameters(this.this$0, freeArgs, this.$reportage, opts, this.$pluginRepository);
            }
        };
    }

    private final TaskParameters parseCountUsagesOfExtensionPointsParameters(List<String> freeArgs, PluginVerificationReportage reportage, CmdOpts opts, PluginRepository pluginRepository) {
        if (!(freeArgs.size() > 3)) {
            boolean $i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$22 = false;
            String $i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$22 = "'countUsagesOfExtensionPoints' goal requires <ide path> <ide plugins path> <output.json>";
            throw new IllegalArgumentException($i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$22.toString());
        }
        String idePath = freeArgs.get(1);
        Object it = freeArgs.get(2);
        boolean bl = false;
        Path path = Paths.get((String)it, new String[0]);
        it = path;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue(it, "it");
        if (!FileUtilKt.exists((Path)it)) {
            boolean $i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$idePluginsRoot$2$22 = false;
            String $i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$idePluginsRoot$2$22 = "Path " + freeArgs.get(2) + " must point to a local root of additional IDE plugins";
            throw new IllegalArgumentException($i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$idePluginsRoot$2$22.toString());
        }
        Path idePluginsRoot = path;
        it = freeArgs.get(3);
        String it2 = (String)it;
        boolean bl3 = false;
        if (!StringsKt.endsWith$default(it2, ".json", false, 2, null)) {
            boolean $i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$outputJson$1$22 = false;
            String $i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$outputJson$1$22 = "must be <output.json> but was " + it2;
            throw new IllegalArgumentException($i$a$-require-ProcessAllPluginsCommand$parseCountUsagesOfExtensionPointsParameters$outputJson$1$22.toString());
        }
        it2 = (String)it;
        boolean bl4 = false;
        Path outputJson = Paths.get(it2, new String[0]);
        reportage.logVerificationStage("Reading IDE " + idePath);
        Closeable $this$closeOnException$iv = OptionsParser.INSTANCE.createIdeDescriptor(idePath, opts);
        boolean $i$f$closeOnException = false;
        try {
            IdeDescriptor ideDescriptor = (IdeDescriptor)$this$closeOnException$iv;
            boolean bl5 = false;
            List compatiblePluginsList2 = (List)RetryUtilKt.retry$default(pluginRepository, "Request plugins compatible with " + ideDescriptor.getIdeVersion(), null, new Function1<PluginRepository, List<? extends PluginInfo>>(ideDescriptor){
                final /* synthetic */ IdeDescriptor $ideDescriptor;
                {
                    this.$ideDescriptor = $ideDescriptor;
                    super(1);
                }

                @NotNull
                public final List<PluginInfo> invoke(@NotNull PluginRepository $this$retry) {
                    Intrinsics.checkNotNullParameter($this$retry, "$this$retry");
                    return $this$retry.getLastCompatiblePlugins(this.$ideDescriptor.getIdeVersion());
                }
            }, 2, null);
            Intrinsics.checkNotNullExpressionValue(idePluginsRoot, "idePluginsRoot");
            PluginRepository localPluginRepository = LocalPluginRepositoryFactory.INSTANCE.createLocalPluginRepository(idePluginsRoot);
            List<PluginInfo> additionalIdePlugins = localPluginRepository.getLastCompatiblePlugins(ideDescriptor.getIdeVersion());
            Intrinsics.checkNotNullExpressionValue(outputJson, "outputJson");
            return new CountUsagesOfExtensionPointsParameters(ideDescriptor, additionalIdePlugins, compatiblePluginsList2, outputJson);
        }
        catch (Throwable e$iv) {
            block5: {
                Closeable closeable = $this$closeOnException$iv;
                if (closeable == null) break block5;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
    }

    public static final /* synthetic */ TaskParameters access$parseCountUsagesOfExtensionPointsParameters(ProcessAllPluginsCommand $this, List freeArgs, PluginVerificationReportage reportage, CmdOpts opts, PluginRepository pluginRepository) {
        return $this.parseCountUsagesOfExtensionPointsParameters(freeArgs, reportage, opts, pluginRepository);
    }
}

