/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/AbstractMethodInvocationProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "bytecodeMethodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "method", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "caller", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "(Lcom/jetbrains/pluginverifier/results/reference/MethodReference;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;)V", "getBytecodeMethodReference", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "getCaller", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getInstruction", "()Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "getMethod", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class AbstractMethodInvocationProblem
extends CompatibilityProblem {
    @NotNull
    private final MethodReference bytecodeMethodReference;
    @NotNull
    private final MethodLocation method;
    @NotNull
    private final MethodLocation caller;
    @NotNull
    private final Instruction instruction;

    public AbstractMethodInvocationProblem(@NotNull MethodReference bytecodeMethodReference, @NotNull MethodLocation method, @NotNull MethodLocation caller2, @NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(bytecodeMethodReference, "bytecodeMethodReference");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(caller2, "caller");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        this.bytecodeMethodReference = bytecodeMethodReference;
        this.method = method;
        this.caller = caller2;
        this.instruction = instruction;
    }

    @NotNull
    public final MethodReference getBytecodeMethodReference() {
        return this.bytecodeMethodReference;
    }

    @NotNull
    public final MethodLocation getMethod() {
        return this.method;
    }

    @NotNull
    public final MethodLocation getCaller() {
        return this.caller;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Abstract method invocation";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.method};
        return FormatUtilsKt.formatMessage("Attempt to invoke an abstract method {0}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{this.caller, this.instruction, this.method};
        return FormatUtilsKt.formatMessage("Method {0} contains an *{1}* instruction referencing a method {2} which doesn''t have an implementation. This can lead to **AbstractMethodError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof AbstractMethodInvocationProblem && Intrinsics.areEqual(this.bytecodeMethodReference, ((AbstractMethodInvocationProblem)other).bytecodeMethodReference) && Intrinsics.areEqual(this.method, ((AbstractMethodInvocationProblem)other).method) && Intrinsics.areEqual(this.caller, ((AbstractMethodInvocationProblem)other).caller) && this.instruction == ((AbstractMethodInvocationProblem)other).instruction;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.bytecodeMethodReference, this.method, this.caller, this.instruction};
        return Objects.hash(objectArray);
    }
}

