/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/AbstractClassInstantiationProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "abstractClass", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "creator", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "(Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;)V", "getAbstractClass", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "getCreator", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class AbstractClassInstantiationProblem
extends CompatibilityProblem {
    @NotNull
    private final ClassLocation abstractClass;
    @NotNull
    private final MethodLocation creator;

    public AbstractClassInstantiationProblem(@NotNull ClassLocation abstractClass, @NotNull MethodLocation creator) {
        Intrinsics.checkNotNullParameter(abstractClass, "abstractClass");
        Intrinsics.checkNotNullParameter(creator, "creator");
        this.abstractClass = abstractClass;
        this.creator = creator;
    }

    @NotNull
    public final ClassLocation getAbstractClass() {
        return this.abstractClass;
    }

    @NotNull
    public final MethodLocation getCreator() {
        return this.creator;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Instantiation of an abstract class";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.abstractClass};
        return FormatUtilsKt.formatMessage("Instantiation of an abstract class {0}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{this.creator, this.abstractClass};
        return FormatUtilsKt.formatMessage("Method {0} has instantiation *new* instruction referencing an abstract class {1}. This can lead to **InstantiationError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof AbstractClassInstantiationProblem && Intrinsics.areEqual(this.abstractClass, ((AbstractClassInstantiationProblem)other).abstractClass) && Intrinsics.areEqual(this.creator, ((AbstractClassInstantiationProblem)other).creator);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.abstractClass, this.creator};
        return Objects.hash(objectArray);
    }
}

