/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.location;

import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.ElementType;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.modifiers.Modifiers;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003JM\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016R\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016\u00a8\u0006,"}, d2={"Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "Lcom/jetbrains/pluginverifier/results/location/Location;", "hostClass", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "methodName", "", "methodDescriptor", "parameterNames", "", "signature", "modifiers", "Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;", "(Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;)V", "containingClass", "getContainingClass", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "elementType", "Lcom/jetbrains/pluginverifier/results/location/ElementType;", "getElementType", "()Lcom/jetbrains/pluginverifier/results/location/ElementType;", "getHostClass", "getMethodDescriptor", "()Ljava/lang/String;", "getMethodName", "getModifiers", "()Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;", "getParameterNames", "()Ljava/util/List;", "presentableLocation", "getPresentableLocation", "getSignature", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class MethodLocation
extends Location {
    @NotNull
    private final ClassLocation hostClass;
    @NotNull
    private final String methodName;
    @NotNull
    private final String methodDescriptor;
    @NotNull
    private final List<String> parameterNames;
    @Nullable
    private final String signature;
    @NotNull
    private final Modifiers modifiers;

    public MethodLocation(@NotNull ClassLocation hostClass, @NotNull String methodName, @NotNull String methodDescriptor, @NotNull List<String> parameterNames, @Nullable String signature2, @NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        Intrinsics.checkNotNullParameter(parameterNames, "parameterNames");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        super(null);
        this.hostClass = hostClass;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.parameterNames = parameterNames;
        this.signature = signature2;
        this.modifiers = modifiers;
    }

    @NotNull
    public final ClassLocation getHostClass() {
        return this.hostClass;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @NotNull
    public final List<String> getParameterNames() {
        return this.parameterNames;
    }

    @Nullable
    public final String getSignature() {
        return this.signature;
    }

    @NotNull
    public final Modifiers getModifiers() {
        return this.modifiers;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof MethodLocation && Intrinsics.areEqual(this.hostClass, ((MethodLocation)other).hostClass) && Intrinsics.areEqual(this.methodName, ((MethodLocation)other).methodName) && Intrinsics.areEqual(this.methodDescriptor, ((MethodLocation)other).methodDescriptor);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.hostClass, this.methodName, this.methodDescriptor};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public String getPresentableLocation() {
        return LocationsPresentationKt.formatMethodLocation(this, HostClassOption.FULL_HOST_WITH_SIGNATURE, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.SIMPLE_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.WITH_PARAM_NAMES_IF_AVAILABLE);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return Intrinsics.areEqual(this.methodName, "<init>") ? ElementType.CONSTRUCTOR : ElementType.METHOD;
    }

    @Override
    @NotNull
    public ClassLocation getContainingClass() {
        return this.hostClass;
    }

    @NotNull
    public final ClassLocation component1() {
        return this.hostClass;
    }

    @NotNull
    public final String component2() {
        return this.methodName;
    }

    @NotNull
    public final String component3() {
        return this.methodDescriptor;
    }

    @NotNull
    public final List<String> component4() {
        return this.parameterNames;
    }

    @Nullable
    public final String component5() {
        return this.signature;
    }

    @NotNull
    public final Modifiers component6() {
        return this.modifiers;
    }

    @NotNull
    public final MethodLocation copy(@NotNull ClassLocation hostClass, @NotNull String methodName, @NotNull String methodDescriptor, @NotNull List<String> parameterNames, @Nullable String signature2, @NotNull Modifiers modifiers) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        Intrinsics.checkNotNullParameter(parameterNames, "parameterNames");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        return new MethodLocation(hostClass, methodName, methodDescriptor, parameterNames, signature2, modifiers);
    }

    public static /* synthetic */ MethodLocation copy$default(MethodLocation methodLocation, ClassLocation classLocation, String string, String string2, List list, String string3, Modifiers modifiers, int n, Object object) {
        if ((n & 1) != 0) {
            classLocation = methodLocation.hostClass;
        }
        if ((n & 2) != 0) {
            string = methodLocation.methodName;
        }
        if ((n & 4) != 0) {
            string2 = methodLocation.methodDescriptor;
        }
        if ((n & 8) != 0) {
            list = methodLocation.parameterNames;
        }
        if ((n & 0x10) != 0) {
            string3 = methodLocation.signature;
        }
        if ((n & 0x20) != 0) {
            modifiers = methodLocation.modifiers;
        }
        return methodLocation.copy(classLocation, string, string2, list, string3, modifiers);
    }
}

