/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.resources;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.repository.resources.LoggerUtilsKt;
import com.jetbrains.pluginverifier.repository.resources.ResourceInfo;
import com.jetbrains.pluginverifier.repository.resources.ResourceWeight;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0007\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u000e\b\u0002\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005B=\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00028\u0001\u00a2\u0006\u0002\u0010!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010#J\u0013\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u0013\u0010&\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00028\u0001\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)RB\u0010\u000e\u001a6\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00100\u000fj\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00028\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00100\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00028\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/pluginverifier/repository/resources/RepositoryResourcesRegistrar;", "R", "K", "W", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;", "", "initWeight", "weigher", "Lkotlin/Function1;", "disposer", "", "logger", "Lorg/slf4j/Logger;", "(Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/slf4j/Logger;)V", "_resources", "Ljava/util/HashMap;", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceInfo;", "Lkotlin/collections/HashMap;", "_totalWeight", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;", "resources", "", "getResources", "()Ljava/util/Map;", "totalWeight", "getTotalWeight", "()Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;", "addResource", "", "key", "resource", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "get", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/resources/ResourceInfo;", "getAllKeys", "", "has", "(Ljava/lang/Object;)Z", "removeResource", "(Ljava/lang/Object;)V", "safeDispose", "(Ljava/lang/Object;Ljava/lang/Object;)V", "verifier-repository"})
public final class RepositoryResourcesRegistrar<R, K, W extends ResourceWeight<W>> {
    @NotNull
    private final Function1<R, W> weigher;
    @NotNull
    private final Function1<R, Unit> disposer;
    @NotNull
    private final Logger logger;
    @NotNull
    private W _totalWeight;
    @NotNull
    private final HashMap<K, ResourceInfo<R, W>> _resources;

    public RepositoryResourcesRegistrar(@NotNull W initWeight, @NotNull Function1<? super R, ? extends W> weigher, @NotNull Function1<? super R, Unit> disposer, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(initWeight, "initWeight");
        Intrinsics.checkNotNullParameter(weigher, "weigher");
        Intrinsics.checkNotNullParameter(disposer, "disposer");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.weigher = weigher;
        this.disposer = disposer;
        this.logger = logger;
        this._totalWeight = initWeight;
        this._resources = new HashMap();
    }

    @NotNull
    public final W getTotalWeight() {
        return this._totalWeight;
    }

    @NotNull
    public final Map<K, ResourceInfo<R, W>> getResources() {
        return MapsKt.toMap((Map)this._resources);
    }

    public final boolean addResource(K key, R resource) {
        try {
            if (((Map)this._resources).containsKey(key)) {
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key, resource){
                    final /* synthetic */ K $key;
                    final /* synthetic */ R $resource;
                    {
                        this.$key = $key;
                        this.$resource = $resource;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "add(" + this.$key + "): the " + this.$resource + " is already available. Disposing the duplicate resource.";
                    }
                });
                this.safeDispose(key, resource);
                return false;
            }
            ResourceWeight resourceWeight = (ResourceWeight)this.weigher.invoke(resource);
            this._totalWeight = this._totalWeight.plus((ResourceWeight)resourceWeight);
            LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key, resource, resourceWeight, this){
                final /* synthetic */ K $key;
                final /* synthetic */ R $resource;
                final /* synthetic */ W $resourceWeight;
                final /* synthetic */ RepositoryResourcesRegistrar<R, K, W> this$0;
                {
                    this.$key = $key;
                    this.$resource = $resource;
                    this.$resourceWeight = $resourceWeight;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "add(" + this.$key + "): adding the " + this.$resource + " of weight " + this.$resourceWeight + ". Total weight: " + RepositoryResourcesRegistrar.access$get_totalWeight$p(this.this$0);
                }
            });
            ((Map)this._resources).put(key, new ResourceInfo<R, ResourceWeight>(resource, resourceWeight));
            return true;
        }
        catch (Throwable e) {
            this.safeDispose(key, resource);
            throw e;
        }
    }

    @NotNull
    public final Set<K> getAllKeys() {
        Set<K> set = this._resources.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "_resources.keys");
        return CollectionsKt.toSet((Iterable)set);
    }

    public final boolean has(K key) {
        return ((Map)this._resources).containsKey(key);
    }

    @Nullable
    public final ResourceInfo<R, W> get(K key) {
        return this._resources.get(key);
    }

    public final void removeResource(K key) {
        if (!((Map)this._resources).containsKey(key)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ResourceInfo<R, W> resourceInfo = this._resources.get(key);
        Intrinsics.checkNotNull(resourceInfo);
        ResourceInfo<R, W> resourceInfo2 = resourceInfo;
        R resource = resourceInfo2.getResource();
        W weight = resourceInfo2.getWeight();
        this._totalWeight = this._totalWeight.minus(weight);
        LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key, resource, weight, this){
            final /* synthetic */ K $key;
            final /* synthetic */ R $resource;
            final /* synthetic */ W $weight;
            final /* synthetic */ RepositoryResourcesRegistrar<R, K, W> this$0;
            {
                this.$key = $key;
                this.$resource = $resource;
                this.$weight = $weight;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "remove(" + this.$key + "): removing the " + this.$resource + " of weight " + this.$weight + ". Total weight: " + RepositoryResourcesRegistrar.access$get_totalWeight$p(this.this$0);
            }
        });
        this._resources.remove(key);
        this.safeDispose(key, resource);
    }

    private final void safeDispose(K key, R resource) {
        try {
            LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                final /* synthetic */ K $key;
                {
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "dispose(" + this.$key + ")";
                }
            });
            this.disposer.invoke(resource);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            this.logger.error("unable to dispose the resource " + resource, e);
        }
    }

    public static final /* synthetic */ ResourceWeight access$get_totalWeight$p(RepositoryResourcesRegistrar $this) {
        return $this._totalWeight;
    }
}

