/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.reporting.common;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.reporting.Reporter;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0016*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0016B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/reporting/common/FileReporter;", "T", "Lcom/jetbrains/pluginverifier/reporting/Reporter;", "file", "Ljava/nio/file/Path;", "lineProvider", "Lkotlin/Function1;", "", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)V", "fileWriter", "Ljava/io/Writer;", "isClosed", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "close", "", "openFileWriter", "Ljava/io/BufferedWriter;", "report", "t", "(Ljava/lang/Object;)V", "Companion", "verifier-intellij"})
public final class FileReporter<T>
implements Reporter<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Path file;
    @NotNull
    private final Function1<T, String> lineProvider;
    @Nullable
    private Writer fileWriter;
    @NotNull
    private final ReentrantLock lock;
    private boolean isClosed;
    @NotNull
    private static final Logger ERROR_LOGGER;

    public FileReporter(@NotNull Path file, @NotNull Function1<? super T, String> lineProvider) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(lineProvider, "lineProvider");
        this.file = file;
        this.lineProvider = lineProvider;
        this.lock = new ReentrantLock(true);
    }

    public /* synthetic */ FileReporter(Path path, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(path, function1);
    }

    private final BufferedWriter openFileWriter() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = Files.newBufferedWriter(FileUtilKt.create(this.file), new OpenOption[0]);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            ERROR_LOGGER.error("Failed to open file writer for " + this.file, e);
            bufferedWriter = null;
        }
        return bufferedWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void report(T t2) {
        String line = this.lineProvider.invoke(t2);
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.isClosed) {
                if (this.fileWriter == null) {
                    this.fileWriter = this.openFileWriter();
                }
                try {
                    Appendable appendable;
                    Writer writer = this.fileWriter;
                    if (writer != null) {
                        Appendable appendable2 = ((Appendable)writer).append(line);
                        Intrinsics.checkNotNullExpressionValue(appendable2, "append(...)");
                        Appendable appendable3 = appendable2.append('\n');
                        appendable = appendable3;
                        Intrinsics.checkNotNullExpressionValue(appendable3, "append(...)");
                    } else {
                        appendable = null;
                    }
                }
                catch (Exception e) {
                    LanguageUtilsKt.rethrowIfInterrupted(e);
                    this.isClosed = true;
                    ERROR_LOGGER.error("Failed to report into " + this.file, e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.isClosed) {
                this.isClosed = true;
                try {
                    Writer writer = this.fileWriter;
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    LanguageUtilsKt.rethrowIfInterrupted(e);
                    ERROR_LOGGER.error("Failed to close file writer for " + this.file, e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(FileReporter.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(FileReporter::class.java)");
        ERROR_LOGGER = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/reporting/common/FileReporter$Companion;", "", "()V", "ERROR_LOGGER", "Lorg/slf4j/Logger;", "getERROR_LOGGER", "()Lorg/slf4j/Logger;", "verifier-intellij"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getERROR_LOGGER() {
            return ERROR_LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

