/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.plugin;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.classes.locator.CompileServerExtensionKey;
import com.jetbrains.plugin.structure.intellij.classes.plugin.BundledPluginClassesFinder;
import com.jetbrains.plugin.structure.intellij.classes.plugin.ClassSearchContext;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesLocations;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.caches.EmptyPluginResourceCache;
import com.jetbrains.plugin.structure.intellij.plugin.caches.PluginResourceCache;
import com.jetbrains.plugin.structure.intellij.problems.IntelliJPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.JetBrainsPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.ZipPluginResource;
import com.jetbrains.plugin.structure.intellij.utils.DeletableOnClose;
import com.jetbrains.pluginverifier.plugin.AbstractPluginDetailsProvider;
import com.jetbrains.pluginverifier.plugin.DependencyDetailsProvider;
import com.jetbrains.pluginverifier.plugin.PluginDetailsProviderImpl;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.files.FileLock;
import com.jetbrains.pluginverifier.repository.repositories.bundled.BundledPluginInfo;
import com.jetbrains.pluginverifier.repository.repositories.dependency.DependencyPluginInfo;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0001*B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0018\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020\u001aH\u0016J \u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010(\u001a\u00020\u0004H\u0002J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider;", "Lcom/jetbrains/pluginverifier/plugin/AbstractPluginDetailsProvider;", "Ljava/lang/AutoCloseable;", "extractDirectory", "Ljava/nio/file/Path;", "pluginCache", "Lcom/jetbrains/plugin/structure/intellij/plugin/caches/PluginResourceCache;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/intellij/plugin/caches/PluginResourceCache;)V", "closeableResources", "", "Ljava/io/Closeable;", "closeableResourcesSize", "", "getCloseableResourcesSize", "()I", "dependencyDetailsProvider", "Lcom/jetbrains/pluginverifier/plugin/DependencyDetailsProvider;", "dependencyProblemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "eventLog", "Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider$EventLog;", "getEventLog", "()Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider$EventLog;", "extractedPluginLocationCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "nonBundledPluginDetailsProvider", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProviderImpl;", "close", "", "createPlugin", "pluginInfo", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "pluginFileLock", "Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "readPluginClasses", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "idePlugin", "cacheExtractedDirectory", "artifactPath", "registerCloseableResources", "EventLog", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nDefaultPluginDetailsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPluginDetailsProvider.kt\ncom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1863#2,2:135\n*S KotlinDebug\n*F\n+ 1 DefaultPluginDetailsProvider.kt\ncom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider\n*L\n89#1:135,2\n*E\n"})
public final class DefaultPluginDetailsProvider
extends AbstractPluginDetailsProvider
implements AutoCloseable {
    @NotNull
    private final PluginResourceCache pluginCache;
    @NotNull
    private final PluginDetailsProviderImpl nonBundledPluginDetailsProvider;
    @NotNull
    private final DependencyDetailsProvider dependencyDetailsProvider;
    @NotNull
    private final PluginCreationResultResolver dependencyProblemResolver;
    @NotNull
    private final ConcurrentHashMap<Path, PluginCreationResult<IdePlugin>> extractedPluginLocationCache;
    @NotNull
    private final List<Closeable> closeableResources;
    @NotNull
    private final EventLog eventLog;

    public DefaultPluginDetailsProvider(@NotNull Path extractDirectory, @NotNull PluginResourceCache pluginCache) {
        Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
        Intrinsics.checkNotNullParameter(pluginCache, "pluginCache");
        super(extractDirectory);
        this.pluginCache = pluginCache;
        this.nonBundledPluginDetailsProvider = new PluginDetailsProviderImpl(extractDirectory, this.pluginCache);
        this.dependencyDetailsProvider = new DependencyDetailsProvider(extractDirectory, this.pluginCache);
        this.dependencyProblemResolver = JetBrainsPluginCreationResultResolver.Companion.fromClassPathJson(new IntelliJPluginCreationResultResolver());
        this.extractedPluginLocationCache = new ConcurrentHashMap();
        this.closeableResources = new ArrayList();
        this.eventLog = new EventLog();
    }

    public /* synthetic */ DefaultPluginDetailsProvider(Path path, PluginResourceCache pluginResourceCache, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            pluginResourceCache = EmptyPluginResourceCache.INSTANCE;
        }
        this(path, pluginResourceCache);
    }

    @Override
    @NotNull
    public IdePluginClassesLocations readPluginClasses(@NotNull PluginInfo pluginInfo, @NotNull IdePlugin idePlugin) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        PluginInfo pluginInfo2 = pluginInfo;
        return pluginInfo2 instanceof BundledPluginInfo ? BundledPluginClassesFinder.Companion.findPluginClasses(idePlugin, CollectionsKt.listOf(CompileServerExtensionKey.INSTANCE), new ClassSearchContext(this.pluginCache, null, 2, null)) : (pluginInfo2 instanceof DependencyPluginInfo ? this.dependencyDetailsProvider.readPluginClasses(pluginInfo, idePlugin) : this.nonBundledPluginDetailsProvider.readPluginClasses(pluginInfo, idePlugin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected PluginCreationResult<IdePlugin> createPlugin(@NotNull PluginInfo pluginInfo, @NotNull FileLock pluginFileLock) {
        PluginCreationResult pluginCreationResult;
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(pluginFileLock, "pluginFileLock");
        if (pluginInfo instanceof DependencyPluginInfo) {
            ConcurrentHashMap<Path, PluginCreationResult<IdePlugin>> concurrentHashMap = this.extractedPluginLocationCache;
            synchronized (concurrentHashMap) {
                PluginCreationResult pluginCreationResult2;
                boolean bl = false;
                Path pluginArtifactPath = pluginFileLock.getFile();
                if (this.extractedPluginLocationCache.containsKey(pluginArtifactPath)) {
                    this.eventLog.logCached(pluginArtifactPath);
                    pluginCreationResult2 = (PluginCreationResult)MapsKt.getValue((Map)this.extractedPluginLocationCache, pluginArtifactPath);
                } else {
                    PluginCreationResult pluginCreationResult3;
                    PluginCreationResult it = pluginCreationResult3 = IdePluginManager.createPlugin$default(this.getIdePluginManager(), pluginArtifactPath, false, null, this.dependencyProblemResolver, false, 4, null);
                    boolean bl2 = false;
                    this.eventLog.logExtracted(pluginArtifactPath);
                    this.cacheExtractedDirectory(this.registerCloseableResources(it), pluginArtifactPath);
                    pluginCreationResult2 = pluginCreationResult3;
                }
                PluginCreationResult pluginCreationResult4 = pluginCreationResult2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                pluginCreationResult = pluginCreationResult4;
            }
        } else {
            pluginCreationResult = super.createPlugin(pluginInfo, pluginFileLock);
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<IdePlugin> registerCloseableResources(PluginCreationResult<? extends IdePlugin> $this$registerCloseableResources) {
        PluginCreationResult<IdePlugin> pluginCreationResult;
        PluginCreationResult<IdePlugin> $this$registerCloseableResources_u24lambda_u243 = pluginCreationResult = $this$registerCloseableResources;
        boolean bl = false;
        if ($this$registerCloseableResources_u24lambda_u243 instanceof PluginCreationSuccess) {
            Iterable $this$forEach$iv = ((PluginCreationSuccess)$this$registerCloseableResources_u24lambda_u243).getResources();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Closeable it = (Closeable)element$iv;
                boolean bl2 = false;
                if (it instanceof ZipPluginResource) {
                    this.pluginCache.plusAssign((ZipPluginResource)it);
                    continue;
                }
                ((Collection)this.closeableResources).add(DeletableOnClose.Companion.of(it));
            }
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<IdePlugin> cacheExtractedDirectory(PluginCreationResult<? extends IdePlugin> $this$cacheExtractedDirectory, Path artifactPath) {
        PluginCreationResult<IdePlugin> pluginCreationResult;
        PluginCreationResult<IdePlugin> $this$cacheExtractedDirectory_u24lambda_u244 = pluginCreationResult = $this$cacheExtractedDirectory;
        boolean bl = false;
        if ($this$cacheExtractedDirectory_u24lambda_u244 instanceof PluginCreationSuccess) {
            ((Map)this.extractedPluginLocationCache).put(artifactPath, $this$cacheExtractedDirectory_u24lambda_u244);
        }
        return pluginCreationResult;
    }

    @Override
    public void close() {
        this.pluginCache.delete();
        this.eventLog.clear();
        LanguageUtilsKt.closeAll(this.closeableResources);
    }

    public final int getCloseableResourcesSize() {
        return this.closeableResources.size();
    }

    @NotNull
    public final EventLog getEventLog() {
        return this.eventLog;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0011\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0007H\u0096\u0002J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider$EventLog;", "Lkotlin/collections/AbstractList;", "", "()V", "events", "", "size", "", "getSize", "()I", "clear", "", "get", "index", "log", "path", "Ljava/nio/file/Path;", "isCached", "", "logCached", "logExtracted", "verifier-repository"})
    public static final class EventLog
    extends AbstractList<String> {
        @NotNull
        private final List<String> events = new ArrayList();

        public final void logCached(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            this.log(path, true);
        }

        public final void logExtracted(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            this.log(path, false);
        }

        public final void log(@NotNull Path path, boolean isCached) {
            Intrinsics.checkNotNullParameter(path, "path");
            ((Collection)this.events).add((isCached ? "cached " : "extracted ") + path);
        }

        @Override
        public int getSize() {
            return this.events.size();
        }

        @Override
        @NotNull
        public String get(int index) {
            return this.events.get(index);
        }

        @Override
        public final void clear() {
            this.events.clear();
        }
    }
}

