/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide;

import com.jetbrains.plugin.structure.ide.IntelliJPlatformProduct;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.ide.AvailableIde;
import com.jetbrains.pluginverifier.ide.repositories.ArtifactJson;
import com.jetbrains.pluginverifier.ide.repositories.IntelliJIdeRepository;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0002J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/pluginverifier/ide/IntelliJRepositoryIndexParser;", "", "()V", "buildDownloadUrl", "Ljava/net/URL;", "artifactInfo", "Lcom/jetbrains/pluginverifier/ide/repositories/ArtifactJson;", "channel", "Lcom/jetbrains/pluginverifier/ide/repositories/IntelliJIdeRepository$Channel;", "groupId", "", "version", "getUniqueIde", "Lcom/jetbrains/pluginverifier/ide/AvailableIde;", "ides", "", "isReleaseLikeVersion", "", "parseArtifacts", "artifacts", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nIntelliJRepositoryIndexParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJRepositoryIndexParser.kt\ncom/jetbrains/pluginverifier/ide/IntelliJRepositoryIndexParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1485#2:117\n1510#2,3:118\n1513#2,3:128\n774#2:132\n865#2,2:133\n1485#2:135\n1510#2,3:136\n1513#2,3:146\n1246#2,4:151\n381#3,7:121\n381#3,7:139\n462#3:149\n412#3:150\n1#4:131\n*S KotlinDebug\n*F\n+ 1 IntelliJRepositoryIndexParser.kt\ncom/jetbrains/pluginverifier/ide/IntelliJRepositoryIndexParser\n*L\n27#1:117\n27#1:118,3\n27#1:128,3\n36#1:132\n36#1:133,2\n63#1:135\n63#1:136,3\n63#1:146,3\n64#1:151,4\n27#1:121,7\n63#1:139,7\n64#1:149\n64#1:150\n*E\n"})
public final class IntelliJRepositoryIndexParser {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AvailableIde> parseArtifacts(@NotNull List<ArtifactJson> artifacts, @NotNull IntelliJIdeRepository.Channel channel) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object groupAndVersion;
        List list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object it;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(artifacts, "artifacts");
        Intrinsics.checkNotNullParameter((Object)channel, "channel");
        ArrayList<AvailableIde> allAvailableIdes = new ArrayList<AvailableIde>();
        Object $this$groupBy$iv = artifacts;
        boolean bl = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (ArtifactJson)element$iv$iv;
            boolean bl2 = false;
            Pair<String, String> key$iv$iv = TuplesKt.to(((ArtifactJson)it).getGroupId(), ((ArtifactJson)it).getVersion());
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedArtifacts = destination$iv$iv;
        for (Map.Entry entry : groupedArtifacts.entrySet()) {
            void $this$filterTo$iv$iv;
            Object object;
            Object v1;
            String version;
            String groupId;
            List artifactsOfVersion;
            block11: {
                groupAndVersion = (Pair)entry.getKey();
                artifactsOfVersion = (List)entry.getValue();
                groupId = (String)((Pair)groupAndVersion).component1();
                version = (String)((Pair)groupAndVersion).component2();
                Iterable key$iv$iv = artifactsOfVersion;
                for (Object $i$f$getOrPut : key$iv$iv) {
                    ArtifactJson it2 = (ArtifactJson)$i$f$getOrPut;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it2.getArtifactId(), "BUILD")) continue;
                    v1 = $i$f$getOrPut;
                    break block11;
                }
                v1 = null;
            }
            if ((object = (ArtifactJson)v1) == null || (object = ((ArtifactJson)object).getContent()) == null) continue;
            Object buildNumber = object;
            Iterable $this$filter$iv = artifactsOfVersion;
            boolean $i$f$filter = false;
            $this$getOrPut$iv$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Object bl3 = $this$filterTo$iv$iv.iterator();
            while (bl3.hasNext()) {
                Object element$iv$iv = bl3.next();
                ArtifactJson it3 = (ArtifactJson)element$iv$iv;
                boolean bl32 = false;
                if (!(Intrinsics.areEqual(it3.getPackaging(), "zip") && IntelliJIdeRepository.Companion.getProductCodeByArtifactId(it3.getArtifactId()) != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List ideArtifacts = (List)destination$iv$iv2;
            for (ArtifactJson artifactInfo : ideArtifacts) {
                IntelliJPlatformProduct product;
                Object bl32;
                IdeVersion ideVersion;
                String productCode;
                if (IntelliJIdeRepository.Companion.getProductCodeByArtifactId(artifactInfo.getArtifactId()) == null || ($i$f$filterTo = (bl3 = IdeVersion.createIdeVersionIfValid((String)buildNumber)) != null ? (IdeVersion)bl3.setProductCodeIfAbsent(productCode) : null) == null || IntelliJPlatformProduct.Companion.fromIdeVersion(ideVersion = $i$f$filterTo) == null) continue;
                URL downloadUrl = this.buildDownloadUrl(artifactInfo, channel, groupId, version);
                boolean isRelease = channel == IntelliJIdeRepository.Channel.RELEASE && this.isReleaseLikeVersion(artifactInfo.getVersion());
                Object it4 = bl32 = version;
                boolean bl4 = false;
                Object releasedVersion = isRelease ? bl32 : null;
                LocalDate uploadDate = Instant.ofEpochMilli(artifactInfo.getLastModifiedUnixTimeMs()).atZone(ZoneOffset.UTC).toLocalDate();
                Intrinsics.checkNotNullExpressionValue(uploadDate, "uploadDate");
                AvailableIde availableIde = new AvailableIde(ideVersion, (String)releasedVersion, downloadUrl, uploadDate, product);
                allAvailableIdes.add(availableIde);
            }
        }
        $this$groupBy$iv = allAvailableIdes;
        boolean bl4 = false;
        groupAndVersion = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (AvailableIde)element$iv$iv;
            boolean bl5 = false;
            IdeVersion key$iv$iv = ((AvailableIde)it).getVersion();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl52 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean bl6 = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it5;
            void it$iv$iv;
            Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl7 = false;
            Map.Entry value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl62 = false;
            AvailableIde availableIde = this.getUniqueIde((List)it5.getValue());
            map2.put(k, availableIde);
        }
        return CollectionsKt.toList(destination$iv$iv.values());
    }

    private final URL buildDownloadUrl(ArtifactJson artifactInfo, IntelliJIdeRepository.Channel channel, String groupId, String version) {
        ArtifactJson $this$buildDownloadUrl_u24lambda_u246 = artifactInfo;
        boolean bl = false;
        return new URL(channel.getRepositoryUrl() + "/" + StringsKt.replace$default(groupId, '.', '/', false, 4, null) + "/" + $this$buildDownloadUrl_u24lambda_u246.getArtifactId() + "/" + version + "/" + $this$buildDownloadUrl_u24lambda_u246.getArtifactId() + "-" + version + "." + $this$buildDownloadUrl_u24lambda_u246.getPackaging());
    }

    /*
     * WARNING - void declaration
     */
    private final AvailableIde getUniqueIde(List<AvailableIde> ides) {
        Object object;
        if (ides.size() == 2) {
            void var2_2;
            AvailableIde first = CollectionsKt.first(ides);
            AvailableIde second = CollectionsKt.last(ides);
            object = first.isRelease() != second.isRelease() ? (first.isRelease() ? first : second) : var2_2;
        } else {
            object = CollectionsKt.first(ides);
        }
        return object;
    }

    private final boolean isReleaseLikeVersion(String version) {
        IdeVersion ideVersion = IdeVersion.createIdeVersionIfValid(version);
        return ideVersion != null && (ideVersion.getBaselineVersion() <= 15 || ideVersion.getBaselineVersion() >= 2016);
    }
}

