/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies;

import com.jetbrains.pluginverifier.dependencies.DependencyEdge;
import com.jetbrains.pluginverifier.dependencies.DependencyNode;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import com.jetbrains.pluginverifier.dependencies.presentation.DependenciesGraphPrettyPrinter;
import com.jetbrains.pluginverifier.dependencies.processing.DependenciesGraphCycleFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\u001b\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u00c6\u0003JO\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\u0005J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u001f\u001a\u00020\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020#H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraph;", "", "verifiedPlugin", "Lcom/jetbrains/pluginverifier/dependencies/DependencyNode;", "vertices", "", "edges", "Lcom/jetbrains/pluginverifier/dependencies/DependencyEdge;", "missingDependencies", "", "", "Lcom/jetbrains/pluginverifier/dependencies/MissingDependency;", "(Lcom/jetbrains/pluginverifier/dependencies/DependencyNode;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getEdges", "()Ljava/util/List;", "getMissingDependencies", "()Ljava/util/Map;", "getVerifiedPlugin", "()Lcom/jetbrains/pluginverifier/dependencies/DependencyNode;", "getVertices", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getAllCycles", "getDirectMissingDependencies", "getEdgesFrom", "dependencyNode", "hashCode", "", "toString", "", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDependenciesGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependenciesGraph.kt\ncom/jetbrains/pluginverifier/dependencies/DependenciesGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n766#2:77\n857#2,2:78\n766#2:80\n857#2,2:81\n*S KotlinDebug\n*F\n+ 1 DependenciesGraph.kt\ncom/jetbrains/pluginverifier/dependencies/DependenciesGraph\n*L\n34#1:77\n34#1:78,2\n43#1:80\n43#1:81,2\n*E\n"})
public final class DependenciesGraph {
    @NotNull
    private final DependencyNode verifiedPlugin;
    @NotNull
    private final List<DependencyNode> vertices;
    @NotNull
    private final List<DependencyEdge> edges;
    @NotNull
    private final Map<DependencyNode, Set<MissingDependency>> missingDependencies;

    public DependenciesGraph(@NotNull DependencyNode verifiedPlugin, @NotNull List<DependencyNode> vertices, @NotNull List<DependencyEdge> edges, @NotNull Map<DependencyNode, ? extends Set<MissingDependency>> missingDependencies) {
        Intrinsics.checkNotNullParameter(verifiedPlugin, "verifiedPlugin");
        Intrinsics.checkNotNullParameter(vertices, "vertices");
        Intrinsics.checkNotNullParameter(edges, "edges");
        Intrinsics.checkNotNullParameter(missingDependencies, "missingDependencies");
        this.verifiedPlugin = verifiedPlugin;
        this.vertices = vertices;
        this.edges = edges;
        this.missingDependencies = missingDependencies;
    }

    @NotNull
    public final DependencyNode getVerifiedPlugin() {
        return this.verifiedPlugin;
    }

    @NotNull
    public final List<DependencyNode> getVertices() {
        return this.vertices;
    }

    @NotNull
    public final List<DependencyEdge> getEdges() {
        return this.edges;
    }

    @NotNull
    public final Map<DependencyNode, Set<MissingDependency>> getMissingDependencies() {
        return this.missingDependencies;
    }

    @NotNull
    public final Set<MissingDependency> getDirectMissingDependencies() {
        return this.missingDependencies.getOrDefault(this.verifiedPlugin, SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DependencyEdge> getEdgesFrom(@NotNull DependencyNode dependencyNode) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(dependencyNode, "dependencyNode");
        Iterable $this$filter$iv = this.edges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DependencyEdge it = (DependencyEdge)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getFrom(), dependencyNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<DependencyNode>> getAllCycles() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = new DependenciesGraphCycleFinder(this).findAllCycles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            if (!it.contains(this.verifiedPlugin)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return new DependenciesGraphPrettyPrinter(this).prettyPresentation();
    }

    @NotNull
    public final DependencyNode component1() {
        return this.verifiedPlugin;
    }

    @NotNull
    public final List<DependencyNode> component2() {
        return this.vertices;
    }

    @NotNull
    public final List<DependencyEdge> component3() {
        return this.edges;
    }

    @NotNull
    public final Map<DependencyNode, Set<MissingDependency>> component4() {
        return this.missingDependencies;
    }

    @NotNull
    public final DependenciesGraph copy(@NotNull DependencyNode verifiedPlugin, @NotNull List<DependencyNode> vertices, @NotNull List<DependencyEdge> edges, @NotNull Map<DependencyNode, ? extends Set<MissingDependency>> missingDependencies) {
        Intrinsics.checkNotNullParameter(verifiedPlugin, "verifiedPlugin");
        Intrinsics.checkNotNullParameter(vertices, "vertices");
        Intrinsics.checkNotNullParameter(edges, "edges");
        Intrinsics.checkNotNullParameter(missingDependencies, "missingDependencies");
        return new DependenciesGraph(verifiedPlugin, vertices, edges, missingDependencies);
    }

    public static /* synthetic */ DependenciesGraph copy$default(DependenciesGraph dependenciesGraph, DependencyNode dependencyNode, List list, List list2, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            dependencyNode = dependenciesGraph.verifiedPlugin;
        }
        if ((n & 2) != 0) {
            list = dependenciesGraph.vertices;
        }
        if ((n & 4) != 0) {
            list2 = dependenciesGraph.edges;
        }
        if ((n & 8) != 0) {
            map = dependenciesGraph.missingDependencies;
        }
        return dependenciesGraph.copy(dependencyNode, list, list2, map);
    }

    public int hashCode() {
        int result2 = this.verifiedPlugin.hashCode();
        result2 = result2 * 31 + ((Object)this.vertices).hashCode();
        result2 = result2 * 31 + ((Object)this.edges).hashCode();
        result2 = result2 * 31 + ((Object)this.missingDependencies).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DependenciesGraph)) {
            return false;
        }
        DependenciesGraph dependenciesGraph = (DependenciesGraph)other;
        if (!Intrinsics.areEqual(this.verifiedPlugin, dependenciesGraph.verifiedPlugin)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.vertices, dependenciesGraph.vertices)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.edges, dependenciesGraph.edges)) {
            return false;
        }
        return Intrinsics.areEqual(this.missingDependencies, dependenciesGraph.missingDependencies);
    }
}

