/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.jar.CachingJarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarArchiveException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/jar/SingletonCachingJarFileSystemProvider;", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "()V", "delegate", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider;", "getFileSystem", "Ljava/nio/file/FileSystem;", "jarPath", "Ljava/nio/file/Path;", "structure-base"})
public final class SingletonCachingJarFileSystemProvider
implements JarFileSystemProvider {
    private static final CachingJarFileSystemProvider delegate;
    @NotNull
    public static final SingletonCachingJarFileSystemProvider INSTANCE;

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        return delegate.getFileSystem(jarPath);
    }

    private SingletonCachingJarFileSystemProvider() {
    }

    static {
        SingletonCachingJarFileSystemProvider singletonCachingJarFileSystemProvider;
        INSTANCE = singletonCachingJarFileSystemProvider = new SingletonCachingJarFileSystemProvider();
        delegate = new CachingJarFileSystemProvider(0L, false, 3, null);
    }

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull Path jarPath, @NotNull JarFileSystemProvider.Configuration configuration) throws JarArchiveException {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        return JarFileSystemProvider.DefaultImpls.getFileSystem(this, jarPath, configuration);
    }
}

