/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.resources;

import com.jetbrains.plugin.structure.base.utils.Deletable;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependenciesKt;
import java.io.Closeable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J5\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\t\u001a\u00020\u0007\u00a2\u0006\n\n\u0002\b\u0011\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/ZipPluginResource;", "Ljava/io/Closeable;", "Lcom/jetbrains/plugin/structure/base/utils/Deletable;", "pluginArtifactPath", "Ljava/nio/file/Path;", "extractedPluginPath", "id", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/PluginId;", "version", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "getExtractedPluginPath", "()Ljava/nio/file/Path;", "getId", "()Ljava/lang/String;", "getPluginArtifactPath", "getVersion", "version$1", "close", "", "component1", "component2", "component3", "component4", "copy", "delete", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "structure-intellij"})
public final class ZipPluginResource
implements Closeable,
Deletable {
    @NotNull
    private final Path pluginArtifactPath;
    @NotNull
    private final Path extractedPluginPath;
    @NotNull
    private final String id;
    @NotNull
    private final String version$1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void close() {
    }

    @Override
    public void delete() {
        Path path = this.extractedPluginPath.getParent();
        Intrinsics.checkNotNullExpressionValue(path, "extractedPluginPath.parent");
        FileUtilKt.deleteLogged(path);
    }

    @NotNull
    public final Path getPluginArtifactPath() {
        return this.pluginArtifactPath;
    }

    @NotNull
    public final Path getExtractedPluginPath() {
        return this.extractedPluginPath;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getVersion() {
        return this.version$1;
    }

    public ZipPluginResource(@NotNull Path pluginArtifactPath, @NotNull Path extractedPluginPath, @NotNull String id, @NotNull String version) {
        Intrinsics.checkNotNullParameter(pluginArtifactPath, "pluginArtifactPath");
        Intrinsics.checkNotNullParameter(extractedPluginPath, "extractedPluginPath");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(version, "version");
        this.pluginArtifactPath = pluginArtifactPath;
        this.extractedPluginPath = extractedPluginPath;
        this.id = id;
        this.version$1 = version;
    }

    @NotNull
    public final Path component1() {
        return this.pluginArtifactPath;
    }

    @NotNull
    public final Path component2() {
        return this.extractedPluginPath;
    }

    @NotNull
    public final String component3() {
        return this.id;
    }

    @NotNull
    public final String component4() {
        return this.version$1;
    }

    @NotNull
    public final ZipPluginResource copy(@NotNull Path pluginArtifactPath, @NotNull Path extractedPluginPath, @NotNull String id, @NotNull String version) {
        Intrinsics.checkNotNullParameter(pluginArtifactPath, "pluginArtifactPath");
        Intrinsics.checkNotNullParameter(extractedPluginPath, "extractedPluginPath");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(version, "version");
        return new ZipPluginResource(pluginArtifactPath, extractedPluginPath, id, version);
    }

    public static /* synthetic */ ZipPluginResource copy$default(ZipPluginResource zipPluginResource, Path path, Path path2, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            path = zipPluginResource.pluginArtifactPath;
        }
        if ((n & 2) != 0) {
            path2 = zipPluginResource.extractedPluginPath;
        }
        if ((n & 4) != 0) {
            string = zipPluginResource.id;
        }
        if ((n & 8) != 0) {
            string2 = zipPluginResource.version$1;
        }
        return zipPluginResource.copy(path, path2, string, string2);
    }

    @NotNull
    public String toString() {
        return "ZipPluginResource(pluginArtifactPath=" + this.pluginArtifactPath + ", extractedPluginPath=" + this.extractedPluginPath + ", id=" + this.id + ", version=" + this.version$1 + ")";
    }

    public int hashCode() {
        Path path = this.pluginArtifactPath;
        Path path2 = this.extractedPluginPath;
        String string = this.id;
        String string2 = this.version$1;
        return (((path != null ? ((Object)path).hashCode() : 0) * 31 + (path2 != null ? ((Object)path2).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ZipPluginResource)) break block3;
                ZipPluginResource zipPluginResource = (ZipPluginResource)object;
                if (!Intrinsics.areEqual(this.pluginArtifactPath, zipPluginResource.pluginArtifactPath) || !Intrinsics.areEqual(this.extractedPluginPath, zipPluginResource.extractedPluginPath) || !Intrinsics.areEqual(this.id, zipPluginResource.id) || !Intrinsics.areEqual(this.version$1, zipPluginResource.version$1)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/ZipPluginResource$Companion;", "", "()V", "version", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "getVersion", "(Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;)Ljava/lang/String;", "of", "Lcom/jetbrains/plugin/structure/intellij/resources/ZipPluginResource;", "pluginArtifactPath", "Ljava/nio/file/Path;", "extractedPluginPath", "plugin", "matches", "", "structure-intellij"})
    public static final class Companion {
        @NotNull
        public final ZipPluginResource of(@NotNull Path pluginArtifactPath, @NotNull Path extractedPluginPath, @NotNull IdePlugin plugin) {
            Intrinsics.checkNotNullParameter(pluginArtifactPath, "pluginArtifactPath");
            Intrinsics.checkNotNullParameter(extractedPluginPath, "extractedPluginPath");
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            return new ZipPluginResource(pluginArtifactPath, extractedPluginPath, DependenciesKt.getId(plugin), this.getVersion(plugin));
        }

        public final boolean matches(@NotNull ZipPluginResource $this$matches, @NotNull Path pluginArtifactPath, @NotNull IdePlugin plugin) {
            Intrinsics.checkNotNullParameter($this$matches, "$this$matches");
            Intrinsics.checkNotNullParameter(pluginArtifactPath, "pluginArtifactPath");
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            return Intrinsics.areEqual($this$matches.getPluginArtifactPath(), pluginArtifactPath) && Intrinsics.areEqual($this$matches.getId(), DependenciesKt.getId(plugin)) && Intrinsics.areEqual($this$matches.getVersion(), this.getVersion(plugin));
        }

        private final String getVersion(IdePlugin $this$version) {
            String string = $this$version.getPluginVersion();
            if (string == null) {
                string = "0";
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

