/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.resources;

import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/CompositeResourceResolver;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "resolvers", "", "(Ljava/util/List;)V", "resolveResource", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result;", "relativePath", "", "basePath", "Ljava/nio/file/Path;", "structure-intellij"})
public final class CompositeResourceResolver
implements ResourceResolver {
    private final List<ResourceResolver> resolvers;

    @Override
    @NotNull
    public ResourceResolver.Result resolveResource(@NotNull String relativePath, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        for (ResourceResolver resolver : this.resolvers) {
            ResourceResolver.Result resourceResult = resolver.resolveResource(relativePath, basePath);
            if (resourceResult instanceof ResourceResolver.Result.NotFound) continue;
            return resourceResult;
        }
        return ResourceResolver.Result.NotFound.INSTANCE;
    }

    public CompositeResourceResolver(@NotNull List<? extends ResourceResolver> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, "resolvers");
        this.resolvers = resolvers;
    }
}

