/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.IncorrectZipOrJarFile;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.telemetry.MutablePluginTelemetry;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.extractor.PluginExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.ModuleDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.OptionalDependencyResolver;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.PluginFileNotFoundException;
import com.jetbrains.plugin.structure.intellij.plugin.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.ContentModuleLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarModuleLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarOrDirectoryPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.LibDirectoryPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.ModuleFromDescriptorLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginDirectoryLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoaderProvider;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModuleLoadingResults;
import com.jetbrains.plugin.structure.intellij.problems.IntelliJPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ZipPluginResource;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00029:B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ:\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001cJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J:\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010$\u001a\u00020#J8\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020#H\u0002J\u0018\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010*\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J0\u0010+\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020#H\u0002J0\u0010,\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010-\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010/\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u00100\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u00101\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u00102\u001a\u00020.*\u00020&2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u000205H\u0002J\u001c\u00106\u001a\u00020.*\u00020&2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u00107\u001a\u000208H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "myResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "extractDirectory", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "contentModuleLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/ContentModuleLoader;", "jarModuleLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarModuleLoader;", "jarOrDirLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarOrDirectoryPluginLoader;", "moduleFromDescriptorLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/ModuleFromDescriptorLoader;", "optionalDependencyResolver", "Lcom/jetbrains/plugin/structure/intellij/plugin/OptionalDependencyResolver;", "pluginLoaderRegistry", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider;", "createBundledModule", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginFile", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "descriptorPath", "", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "createBundledPlugin", "fallbackPluginId", "createPlugin", "validateDescriptor", "", "deleteExtractedDirectory", "extractZipAndCreatePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "resourceResolver", "getInvalidPluginFileCreator", "pluginFileName", "getPluginCreator", "getPluginCreatorWithResult", "getPluginExtractorFromJarOrDirectory", "resolveContentModules", "", "contentModulesOwner", "resolveOptionalDependencies", "pluginCreator", "addContentModule", "resolvedContentModule", "moduleDescriptor", "Lcom/jetbrains/plugin/structure/intellij/plugin/ModuleDescriptor;", "setTelemetry", "pluginCreationDurationInMillis", "", "Companion", "CreationResult", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nIdePluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 PluginLoaderProvider.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider\n*L\n1#1,331:1\n1855#2,2:332\n1855#2,2:334\n1#3:336\n17#4,6:337\n21#5:343\n21#5:344\n21#5:345\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager\n*L\n107#1,2:332\n110#1,2:334\n243#1,6:337\n66#1:343\n67#1:344\n68#1:345\n*E\n"})
public final class IdePluginManager
implements PluginManager<IdePlugin> {
    private final PluginLoaderProvider pluginLoaderRegistry;
    private final ModuleFromDescriptorLoader moduleFromDescriptorLoader;
    private final JarModuleLoader jarModuleLoader;
    private final JarOrDirectoryPluginLoader jarOrDirLoader;
    private final ContentModuleLoader contentModuleLoader;
    private final OptionalDependencyResolver optionalDependencyResolver;
    private final ResourceResolver myResourceResolver;
    private final Path extractDirectory;
    private final JarFileSystemProvider fileSystemProvider;
    private static final Logger LOG;
    @NotNull
    public static final String PLUGIN_XML = "plugin.xml";
    @NotNull
    public static final String META_INF = "META-INF";
    @NotNull
    public static final Companion Companion;

    private final void resolveOptionalDependencies(Path pluginFile, PluginCreator pluginCreator, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        if (pluginCreator.isSuccess()) {
            this.optionalDependencyResolver.resolveOptionalDependencies(pluginCreator, pluginFile, resourceResolver, problemResolver);
        }
    }

    private final void resolveContentModules(Path pluginFile, PluginCreator contentModulesOwner, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        Object it;
        ContentModuleLoadingResults contentModuleLoadingResults;
        ContentModuleLoadingResults $this$with = contentModuleLoadingResults = this.contentModuleLoader.resolveContentModules$structure_intellij(pluginFile, contentModulesOwner, resourceResolver, problemResolver);
        boolean bl = false;
        Iterable $this$forEach$iv = $this$with.getContentModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ContentModuleLoadingResults.ResolvedContentModuleWithDescriptor)element$iv;
            boolean bl2 = false;
            this.addContentModule(contentModulesOwner, ((ContentModuleLoadingResults.ResolvedContentModuleWithDescriptor)it).getContentModule(), ((ContentModuleLoadingResults.ResolvedContentModuleWithDescriptor)it).getDescriptor());
        }
        $this$forEach$iv = $this$with.getProblems();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PluginProblem)element$iv;
            boolean bl3 = false;
            contentModulesOwner.registerProblem$structure_intellij((PluginProblem)it);
        }
    }

    private final void addContentModule(PluginCreator $this$addContentModule, IdePlugin resolvedContentModule, ModuleDescriptor moduleDescriptor) {
        $this$addContentModule.getPlugin$structure_intellij().getModulesDescriptors().add(moduleDescriptor);
        $this$addContentModule.getPlugin$structure_intellij().getDefinedModules().add(moduleDescriptor.getName());
        $this$addContentModule.mergeContent$structure_intellij(resolvedContentModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator extractZipAndCreatePlugin(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver, boolean deleteExtractedDirectory) {
        Object object;
        ExtractorResult extractorResult;
        ExtractorResult extractorResult2;
        try {
            extractorResult2 = PluginExtractor.INSTANCE.extractPlugin(pluginFile, this.extractDirectory);
        }
        catch (Exception e) {
            LOG.info("Unable to extract plugin zip " + FileUtilKt.getSimpleName(pluginFile), e);
            return PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName(pluginFile), descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        extractorResult2 = extractorResult = extractorResult2;
        if (extractorResult2 instanceof ExtractorResult.Success) {
            ExtractedPlugin extractedPlugin = ((ExtractorResult.Success)extractorResult).getExtractedPlugin();
            if (deleteExtractedDirectory) {
                Closeable closeable = extractedPlugin;
                Throwable throwable = null;
                try {
                    Object $dstr$extractedFile = (ExtractedPlugin)closeable;
                    boolean bl = false;
                    Path extractedFile = ((ExtractedPlugin)$dstr$extractedFile).component1();
                    $dstr$extractedFile = this.getPluginExtractorFromJarOrDirectory(extractedFile, descriptorPath, validateDescriptor, resourceResolver, problemResolver);
                    object = $dstr$extractedFile;
                }
                catch (Throwable $dstr$extractedFile) {
                    throwable = $dstr$extractedFile;
                    throw $dstr$extractedFile;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            } else {
                PluginCreator pluginCreator;
                Path extractedDir = extractedPlugin.getPluginFile();
                PluginCreator $this$apply = pluginCreator = this.getPluginExtractorFromJarOrDirectory(extractedDir, descriptorPath, validateDescriptor, resourceResolver, problemResolver);
                boolean bl = false;
                Collection collection = $this$apply.getResources$structure_intellij();
                ZipPluginResource zipPluginResource = ZipPluginResource.Companion.of(pluginFile, extractedDir, $this$apply.getPlugin$structure_intellij());
                collection.add(zipPluginResource);
                object = pluginCreator;
            }
        } else if (extractorResult2 instanceof ExtractorResult.Fail) {
            object = PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName(pluginFile), descriptorPath, ((ExtractorResult.Fail)extractorResult).getPluginProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final PluginCreator getPluginExtractorFromJarOrDirectory(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        return FileUtilKt.isJar(pluginFile) || FileUtilKt.isDirectory(pluginFile) ? this.getPluginCreator(pluginFile, descriptorPath, validateDescriptor, resourceResolver, problemResolver) : this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName(pluginFile), descriptorPath);
    }

    @Override
    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        return IdePluginManager.createPlugin$default(this, pluginFile, true, null, null, false, 28, null);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile, boolean validateDescriptor, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver, boolean deleteExtractedDirectory) throws PluginFileNotFoundException {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
        PluginCreator pluginCreator = this.getPluginCreatorWithResult(pluginFile, validateDescriptor, descriptorPath, problemResolver, deleteExtractedDirectory);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createPlugin$default(IdePluginManager idePluginManager, Path path, boolean bl, String string, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) throws PluginFileNotFoundException {
        if ((n & 4) != 0) {
            string = PLUGIN_XML;
        }
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return idePluginManager.createPlugin(path, bl, string, pluginCreationResultResolver, bl2);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledPlugin(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver, @Nullable String fallbackPluginId) throws PluginFileNotFoundException {
        PluginCreator pluginCreator;
        block0: {
            String string;
            Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
            Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            pluginCreator = this.getPluginCreatorWithResult(pluginFile, false, descriptorPath, problemResolver, false);
            String string2 = ideVersion.asStringWithoutProductCode();
            Intrinsics.checkNotNullExpressionValue(string2, "ideVersion.asStringWithoutProductCode()");
            pluginCreator.setPluginVersion(string2);
            String string3 = fallbackPluginId;
            if (string3 == null) break block0;
            String it = string = string3;
            boolean bl = false;
            pluginCreator.setPluginIdIfNull(it);
        }
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createBundledPlugin$default(IdePluginManager idePluginManager, Path path, IdeVersion ideVersion, String string, PluginCreationResultResolver pluginCreationResultResolver, String string2, int n, Object object) throws PluginFileNotFoundException {
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return idePluginManager.createBundledPlugin(path, ideVersion, string, pluginCreationResultResolver, string2);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledModule(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
        PluginCreator $this$apply = pluginCreator = this.jarModuleLoader.loadPlugin(new JarModuleLoader.Context(pluginFile, descriptorPath, this.myResourceResolver, problemResolver));
        boolean bl = false;
        String string = ideVersion.asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue(string, "ideVersion.asStringWithoutProductCode()");
        $this$apply.setPluginVersion(string);
        $this$apply.setOriginalFile(pluginFile);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createBundledModule$default(IdePluginManager idePluginManager, Path path, IdeVersion ideVersion, String string, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) {
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        return idePluginManager.createBundledModule(path, ideVersion, string, pluginCreationResultResolver);
    }

    private final PluginCreator getPluginCreatorWithResult(Path pluginFile, boolean validateDescriptor, String descriptorPath, PluginCreationResultResolver problemResolver, boolean deleteExtractedDirectory) throws PluginFileNotFoundException {
        long l;
        if (!FileUtilKt.exists(pluginFile)) {
            throw (Throwable)new PluginFileNotFoundException(pluginFile);
        }
        PluginCreator pluginCreator = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        pluginCreator = FileUtilKt.isZip(pluginFile) ? this.extractZipAndCreatePlugin(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, problemResolver, deleteExtractedDirectory) : (FileUtilKt.isJar(pluginFile) || FileUtilKt.isDirectory(pluginFile) ? this.getPluginCreator(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, problemResolver) : this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName(pluginFile), descriptorPath));
        pluginCreator.setOriginalFile(pluginFile);
        long pluginCreationDuration = l = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        this.setTelemetry(pluginCreator, pluginFile, pluginCreationDuration);
        return pluginCreator;
    }

    private final PluginCreator getPluginCreator(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator = this.jarOrDirLoader.loadPlugin(new JarOrDirectoryPluginLoader.Context(pluginFile, descriptorPath, validateDescriptor, resourceResolver, null, problemResolver, false, 64, null));
        this.resolveOptionalDependencies(pluginFile, pluginCreator, this.myResourceResolver, problemResolver);
        this.resolveContentModules(pluginFile, pluginCreator, this.myResourceResolver, problemResolver);
        return pluginCreator;
    }

    private final PluginCreator getInvalidPluginFileCreator(String pluginFileName, String descriptorPath) {
        return PluginCreator.Companion.createInvalidPlugin(pluginFileName, descriptorPath, (PluginProblem)new IncorrectZipOrJarFile(pluginFileName));
    }

    private final void setTelemetry(PluginCreator $this$setTelemetry, Path pluginFile, long pluginCreationDurationInMillis) {
        MutablePluginTelemetry mutablePluginTelemetry;
        MutablePluginTelemetry $this$with = mutablePluginTelemetry = $this$setTelemetry.getTelemetry();
        boolean bl = false;
        $this$with.setParsingDuration(Duration.ofMillis(pluginCreationDurationInMillis));
        $this$with.setArchiveFileSize(FileUtilKt.getPluginSize(pluginFile));
    }

    /*
     * WARNING - void declaration
     */
    private IdePluginManager(ResourceResolver myResourceResolver, Path extractDirectory, JarFileSystemProvider fileSystemProvider) {
        void $this$apply;
        PluginLoaderProvider pluginLoaderProvider;
        this.myResourceResolver = myResourceResolver;
        this.extractDirectory = extractDirectory;
        this.fileSystemProvider = fileSystemProvider;
        PluginLoaderProvider pluginLoaderProvider2 = pluginLoaderProvider = new PluginLoaderProvider();
        IdePluginManager idePluginManager = this;
        boolean bl = false;
        $this$apply.register$structure_intellij(JarPluginLoader.Context.class, new JarPluginLoader(this.fileSystemProvider));
        $this$apply.register$structure_intellij(JarModuleLoader.Context.class, new JarModuleLoader(this.fileSystemProvider));
        $this$apply.register$structure_intellij(PluginDirectoryLoader.Context.class, new PluginDirectoryLoader((PluginLoaderProvider)$this$apply));
        $this$apply.register$structure_intellij(LibDirectoryPluginLoader.Context.class, new LibDirectoryPluginLoader((PluginLoaderProvider)$this$apply, this.fileSystemProvider));
        $this$apply.register$structure_intellij(ModuleFromDescriptorLoader.Context.class, new ModuleFromDescriptorLoader());
        $this$apply.register$structure_intellij(JarOrDirectoryPluginLoader.Context.class, new JarOrDirectoryPluginLoader((PluginLoaderProvider)$this$apply));
        Unit unit = Unit.INSTANCE;
        idePluginManager.pluginLoaderRegistry = pluginLoaderProvider;
        PluginLoaderProvider this_$iv = this.pluginLoaderRegistry;
        boolean $i$f$get$structure_intellij = false;
        com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader<ModuleFromDescriptorLoader.Context> pluginLoader = this_$iv.get$structure_intellij(ModuleFromDescriptorLoader.Context.class);
        if (pluginLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.ModuleFromDescriptorLoader");
        }
        this.moduleFromDescriptorLoader = (ModuleFromDescriptorLoader)((com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader)((ModuleFromDescriptorLoader)pluginLoader));
        this_$iv = this.pluginLoaderRegistry;
        $i$f$get$structure_intellij = false;
        com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader<JarModuleLoader.Context> pluginLoader2 = this_$iv.get$structure_intellij(JarModuleLoader.Context.class);
        if (pluginLoader2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.JarModuleLoader");
        }
        this.jarModuleLoader = (JarModuleLoader)((com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader)((JarModuleLoader)pluginLoader2));
        this_$iv = this.pluginLoaderRegistry;
        $i$f$get$structure_intellij = false;
        com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader<JarOrDirectoryPluginLoader.Context> pluginLoader3 = this_$iv.get$structure_intellij(JarOrDirectoryPluginLoader.Context.class);
        if (pluginLoader3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.JarOrDirectoryPluginLoader");
        }
        this.jarOrDirLoader = (JarOrDirectoryPluginLoader)((com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader)((JarOrDirectoryPluginLoader)pluginLoader3));
        this.contentModuleLoader = new ContentModuleLoader(this.jarOrDirLoader, this.moduleFromDescriptorLoader);
        this.optionalDependencyResolver = new OptionalDependencyResolver(new PluginLoader(this){
            final /* synthetic */ IdePluginManager this$0;

            @NotNull
            public PluginCreator load(@NotNull Path pluginFile, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver) {
                Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
                Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
                Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
                Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
                return IdePluginManager.access$getJarOrDirLoader$p(this.this$0).loadPlugin(new JarOrDirectoryPluginLoader.Context(pluginFile, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, false, 64, null));
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    /* synthetic */ IdePluginManager(ResourceResolver resourceResolver, Path path, JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            jarFileSystemProvider = SingletonCachingJarFileSystemProvider.INSTANCE;
        }
        this(resourceResolver, path, jarFileSystemProvider);
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(IdePluginManager.class);
    }

    @Override
    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="createPlugin(pluginFile.toPath())"), message="Use method with java.nio.Path instead of java.io.File")
    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        return PluginManager.DefaultImpls.createPlugin(this, pluginFile);
    }

    public static final /* synthetic */ JarOrDirectoryPluginLoader access$getJarOrDirLoader$p(IdePluginManager $this) {
        return $this.jarOrDirLoader;
    }

    public /* synthetic */ IdePluginManager(ResourceResolver myResourceResolver, Path extractDirectory, JarFileSystemProvider fileSystemProvider, DefaultConstructorMarker $constructor_marker) {
        this(myResourceResolver, extractDirectory, fileSystemProvider);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager() {
        return Companion.createManager();
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
        return Companion.createManager(resourceResolver);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull Path extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory, @NotNull JarFileSystemProvider fileSystemProvider) {
        return Companion.createManager(resourceResolver, extractDirectory, fileSystemProvider);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(extractDirectory.toPath())"))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull File extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(resourceResolver, extractDirectory.toPath())"))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$CreationResult;", "", "artifact", "Ljava/nio/file/Path;", "creator", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;)V", "getArtifact", "()Ljava/nio/file/Path;", "getCreator", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "structure-intellij"})
    public static final class CreationResult {
        @NotNull
        private final Path artifact;
        @NotNull
        private final PluginCreator creator;

        @NotNull
        public final Path getArtifact() {
            return this.artifact;
        }

        @NotNull
        public final PluginCreator getCreator() {
            return this.creator;
        }

        public CreationResult(@NotNull Path artifact, @NotNull PluginCreator creator) {
            Intrinsics.checkNotNullParameter(artifact, "artifact");
            Intrinsics.checkNotNullParameter(creator, "creator");
            this.artifact = artifact;
            this.creator = creator;
        }

        @NotNull
        public final Path component1() {
            return this.artifact;
        }

        @NotNull
        public final PluginCreator component2() {
            return this.creator;
        }

        @NotNull
        public final CreationResult copy(@NotNull Path artifact, @NotNull PluginCreator creator) {
            Intrinsics.checkNotNullParameter(artifact, "artifact");
            Intrinsics.checkNotNullParameter(creator, "creator");
            return new CreationResult(artifact, creator);
        }

        public static /* synthetic */ CreationResult copy$default(CreationResult creationResult, Path path, PluginCreator pluginCreator, int n, Object object) {
            if ((n & 1) != 0) {
                path = creationResult.artifact;
            }
            if ((n & 2) != 0) {
                pluginCreator = creationResult.creator;
            }
            return creationResult.copy(path, pluginCreator);
        }

        @NotNull
        public String toString() {
            return "CreationResult(artifact=" + this.artifact + ", creator=" + this.creator + ")";
        }

        public int hashCode() {
            Path path = this.artifact;
            PluginCreator pluginCreator = this.creator;
            return (path != null ? ((Object)path).hashCode() : 0) * 31 + (pluginCreator != null ? pluginCreator.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CreationResult)) break block3;
                    CreationResult creationResult = (CreationResult)object;
                    if (!Intrinsics.areEqual(this.artifact, creationResult.artifact) || !Intrinsics.areEqual(this.creator, creationResult.creator)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000fH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "META_INF", "", "PLUGIN_XML", "createManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "extractDirectory", "Ljava/io/File;", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "structure-intellij"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager() {
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            return this.createManager(resourceResolver, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, extractDirectory);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            return new IdePluginManager(resourceResolver, extractDirectory, null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory, @NotNull JarFileSystemProvider fileSystemProvider) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
            return new IdePluginManager(resourceResolver, extractDirectory, fileSystemProvider, null);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(extractDirectory.toPath())"))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull File extractDirectory) {
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            ResourceResolver resourceResolver = DefaultResourceResolver.INSTANCE;
            Path path = extractDirectory.toPath();
            Intrinsics.checkNotNullExpressionValue(path, "extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(resourceResolver, extractDirectory.toPath())"))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
            Path path = extractDirectory.toPath();
            Intrinsics.checkNotNullExpressionValue(path, "extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

