/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.classes.plugin;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.classes.locator.ClassesDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.JarPluginKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibModulesDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LocationKey;
import com.jetbrains.plugin.structure.intellij.classes.plugin.ClassSearchContext;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesFinder;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesLocations;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.extractor.PluginExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.caches.PluginResourceCache;
import com.jetbrains.plugin.structure.intellij.resources.ZipPluginResource;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\t0\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder;", "", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "extractDirectory", "Ljava/nio/file/Path;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "locatorKeys", "", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "pluginResourceCache", "Lcom/jetbrains/plugin/structure/intellij/plugin/caches/PluginResourceCache;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Ljava/util/List;Lcom/jetbrains/plugin/structure/intellij/plugin/caches/PluginResourceCache;)V", "extractAndGetClasses", "Lkotlin/Pair;", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "pluginZipPath", "findInZip", "pluginZip", "findLocations", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "pluginFile", "findPluginClasses", "matches", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/intellij/resources/ZipPluginResource;", "", "Companion", "structure-intellij-classes"})
@SourceDebugExtension(value={"SMAP\nIdePluginClassesFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginClassesFinder.kt\ncom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n70#2,5:159\n1855#3,2:164\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginClassesFinder.kt\ncom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder\n*L\n92#1,5:159\n112#1,2:164\n*E\n"})
public final class IdePluginClassesFinder {
    private final IdePlugin idePlugin;
    private final Path extractDirectory;
    private final Resolver.ReadMode readMode;
    private final List<LocationKey> locatorKeys;
    private final PluginResourceCache pluginResourceCache;
    @NotNull
    private static final List<LocationKey> MAIN_CLASSES_KEYS;
    @NotNull
    public static final Companion Companion;

    private final IdePluginClassesLocations findPluginClasses() {
        IdePluginClassesLocations idePluginClassesLocations;
        Path pluginFile = this.idePlugin.getOriginalFile();
        if (pluginFile == null) {
            return new IdePluginClassesLocations(this.idePlugin, findPluginClasses.1.INSTANCE, MapsKt.emptyMap());
        }
        if (!FileUtilKt.exists(pluginFile)) {
            throw (Throwable)new IllegalArgumentException("Plugin file doesn't exist " + pluginFile);
        }
        if (!(FileUtilKt.isDirectory(pluginFile) || FileUtilKt.isJar(pluginFile) || FileUtilKt.isZip(pluginFile))) {
            throw (Throwable)new IllegalArgumentException("Incorrect plugin file type " + pluginFile + ": expected a directory, a .zip or a .jar archive");
        }
        if (FileUtilKt.isZip(pluginFile)) {
            idePluginClassesLocations = this.findInZip(pluginFile);
        } else {
            Map<LocationKey, List<Resolver>> locations = this.findLocations(pluginFile);
            idePluginClassesLocations = new IdePluginClassesLocations(this.idePlugin, findPluginClasses.2.INSTANCE, locations);
        }
        return idePluginClassesLocations;
    }

    /*
     * WARNING - void declaration
     */
    private final IdePluginClassesLocations findInZip(Path pluginZip) {
        IdePluginClassesLocations idePluginClassesLocations;
        PluginResourceCache.Result cachedResult = this.pluginResourceCache.findFirst(this.matches(pluginZip));
        PluginResourceCache.Result result2 = cachedResult;
        if (result2 instanceof PluginResourceCache.Result.Found) {
            ZipPluginResource zipPluginResource;
            ZipPluginResource it = zipPluginResource = ((PluginResourceCache.Result.Found)cachedResult).getPluginResource();
            boolean bl = false;
            idePluginClassesLocations = new IdePluginClassesLocations(this.idePlugin, it, this.findLocations(it.getExtractedPluginPath()));
        } else if (result2 instanceof PluginResourceCache.Result.NotFound) {
            void extractedPluginPath;
            Pair<Path, IdePluginClassesLocations> pair;
            Pair<Path, IdePluginClassesLocations> $dstr$extractedPluginPath$locations = pair = this.extractAndGetClasses(pluginZip);
            boolean bl = false;
            Path path = $dstr$extractedPluginPath$locations.component1();
            IdePluginClassesLocations locations = $dstr$extractedPluginPath$locations.component2();
            this.pluginResourceCache.plusAssign(ZipPluginResource.Companion.of(pluginZip, (Path)extractedPluginPath, this.idePlugin));
            idePluginClassesLocations = locations;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return idePluginClassesLocations;
    }

    private final Function1<ZipPluginResource, Boolean> matches(Path $this$matches) {
        return new Function1<ZipPluginResource, Boolean>(this, $this$matches){
            final /* synthetic */ IdePluginClassesFinder this$0;
            final /* synthetic */ Path $this_matches;

            public final boolean invoke(@NotNull ZipPluginResource zipResource) {
                Intrinsics.checkNotNullParameter(zipResource, "zipResource");
                return ZipPluginResource.Companion.matches(zipResource, this.$this_matches, IdePluginClassesFinder.access$getIdePlugin$p(this.this$0));
            }
            {
                this.this$0 = idePluginClassesFinder;
                this.$this_matches = path;
                super(1);
            }
        };
    }

    private final Pair<Path, IdePluginClassesLocations> extractAndGetClasses(Path pluginZipPath) throws IOException {
        Pair<Path, IdePluginClassesLocations> pair;
        ExtractorResult extractorResult = PluginExtractor.INSTANCE.extractPlugin(pluginZipPath, this.extractDirectory);
        if (extractorResult instanceof ExtractorResult.Success) {
            Closeable $this$closeOnException$iv = ((ExtractorResult.Success)extractorResult).getExtractedPlugin();
            boolean $i$f$closeOnException = false;
            try {
                ExtractedPlugin it = (ExtractedPlugin)$this$closeOnException$iv;
                boolean bl = false;
                Map<LocationKey, List<Resolver>> locations = this.findLocations(it.getPluginFile());
                pair = TuplesKt.to(it.getPluginFile(), new IdePluginClassesLocations(this.idePlugin, it, locations));
            }
            catch (Throwable e$iv) {
                Closeable closeable = $this$closeOnException$iv;
                if (closeable != null) {
                    LanguageUtilsKt.closeLogged(closeable);
                }
                throw e$iv;
            }
        } else {
            if (extractorResult instanceof ExtractorResult.Fail) {
                throw (Throwable)new IOException(((ExtractorResult.Fail)extractorResult).getPluginProblem().getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    private final Map<LocationKey, List<Resolver>> findLocations(Path pluginFile) {
        HashMap locations = new HashMap();
        try {
            for (LocationKey locatorKey : this.locatorKeys) {
                LanguageUtilsKt.checkIfInterrupted();
                List<Resolver> resolvers = locatorKey.getLocator(this.readMode).findClasses(this.idePlugin, pluginFile);
                ((Map)locations).put(locatorKey, resolvers);
            }
        }
        catch (Throwable e) {
            Iterator iterator2 = locations.values().iterator();
            while (iterator2.hasNext()) {
                List resolvers;
                List list = resolvers = (List)iterator2.next();
                Intrinsics.checkNotNullExpressionValue(list, "resolvers");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl = false;
                    LanguageUtilsKt.closeLogged((Closeable)it);
                }
            }
            throw e;
        }
        return locations;
    }

    private IdePluginClassesFinder(IdePlugin idePlugin, Path extractDirectory, Resolver.ReadMode readMode, List<? extends LocationKey> locatorKeys, PluginResourceCache pluginResourceCache) {
        this.idePlugin = idePlugin;
        this.extractDirectory = extractDirectory;
        this.readMode = readMode;
        this.locatorKeys = locatorKeys;
        this.pluginResourceCache = pluginResourceCache;
    }

    static {
        Companion = new Companion(null);
        MAIN_CLASSES_KEYS = CollectionsKt.listOf(JarPluginKey.INSTANCE, ClassesDirectoryKey.INSTANCE, LibDirectoryKey.INSTANCE, LibModulesDirectoryKey.INSTANCE);
    }

    public static final /* synthetic */ IdePlugin access$getIdePlugin$p(IdePluginClassesFinder $this) {
        return $this.idePlugin;
    }

    public /* synthetic */ IdePluginClassesFinder(IdePlugin idePlugin, Path extractDirectory, Resolver.ReadMode readMode, List locatorKeys, PluginResourceCache pluginResourceCache, DefaultConstructorMarker $constructor_marker) {
        this(idePlugin, extractDirectory, readMode, locatorKeys, pluginResourceCache);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J&\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder$Companion;", "", "()V", "MAIN_CLASSES_KEYS", "", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "getMAIN_CLASSES_KEYS", "()Ljava/util/List;", "find", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "explicitLocations", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "searchContext", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/ClassSearchContext;", "findPluginClasses", "additionalKeys", "fullyFindPluginClassesInExplicitLocations", "locations", "structure-intellij-classes"})
    public static final class Companion {
        @NotNull
        public final List<LocationKey> getMAIN_CLASSES_KEYS() {
            return MAIN_CLASSES_KEYS;
        }

        @NotNull
        public final IdePluginClassesLocations findPluginClasses(@NotNull IdePlugin idePlugin, @NotNull List<? extends LocationKey> additionalKeys) {
            Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
            Intrinsics.checkNotNullParameter(additionalKeys, "additionalKeys");
            return this.find(idePlugin, CollectionsKt.plus((Collection)this.getMAIN_CLASSES_KEYS(), (Iterable)additionalKeys), Resolver.ReadMode.FULL, new ClassSearchContext(null, null, 3, null));
        }

        public static /* synthetic */ IdePluginClassesLocations findPluginClasses$default(Companion companion, IdePlugin idePlugin, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.findPluginClasses(idePlugin, list);
        }

        @NotNull
        public final IdePluginClassesLocations findPluginClasses(@NotNull IdePlugin idePlugin, @NotNull List<? extends LocationKey> additionalKeys, @NotNull ClassSearchContext searchContext) {
            Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
            Intrinsics.checkNotNullParameter(additionalKeys, "additionalKeys");
            Intrinsics.checkNotNullParameter(searchContext, "searchContext");
            return this.find(idePlugin, CollectionsKt.plus((Collection)this.getMAIN_CLASSES_KEYS(), (Iterable)additionalKeys), Resolver.ReadMode.FULL, searchContext);
        }

        public static /* synthetic */ IdePluginClassesLocations findPluginClasses$default(Companion companion, IdePlugin idePlugin, List list, ClassSearchContext classSearchContext, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.findPluginClasses(idePlugin, list, classSearchContext);
        }

        @NotNull
        public final IdePluginClassesLocations fullyFindPluginClassesInExplicitLocations(@NotNull IdePlugin idePlugin, @NotNull List<? extends LocationKey> locations, @NotNull ClassSearchContext searchContext) {
            Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
            Intrinsics.checkNotNullParameter(locations, "locations");
            Intrinsics.checkNotNullParameter(searchContext, "searchContext");
            return this.find(idePlugin, locations, Resolver.ReadMode.FULL, searchContext);
        }

        private final IdePluginClassesLocations find(IdePlugin idePlugin, List<? extends LocationKey> explicitLocations, Resolver.ReadMode readMode, ClassSearchContext searchContext) {
            return new IdePluginClassesFinder(idePlugin, searchContext.getExtractDirectory(), readMode, explicitLocations, searchContext.getPluginCache(), null).findPluginClasses();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

