/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.classes.locator;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.classes.resolvers.LazyJarResolver;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.classes.locator.ClassesLocator;
import com.jetbrains.plugin.structure.intellij.classes.locator.FileOriginProvider;
import com.jetbrains.plugin.structure.intellij.classes.locator.JarPluginKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LocationKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.SingleJarFileOriginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/locator/JarPluginLocator;", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/ClassesLocator;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "fileOriginProvider", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/FileOriginProvider;", "(Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Lcom/jetbrains/plugin/structure/intellij/classes/locator/FileOriginProvider;)V", "locationKey", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "getLocationKey", "()Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "findClasses", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginFile", "Ljava/nio/file/Path;", "structure-intellij-classes"})
public final class JarPluginLocator
implements ClassesLocator {
    @NotNull
    private final LocationKey locationKey;
    private final Resolver.ReadMode readMode;
    private final FileOriginProvider fileOriginProvider;

    @Override
    @NotNull
    public LocationKey getLocationKey() {
        return this.locationKey;
    }

    @Override
    @NotNull
    public List<Resolver> findClasses(@NotNull IdePlugin idePlugin, @NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        if (FileUtilKt.isJar(pluginFile)) {
            return CollectionsKt.listOf(new LazyJarResolver(pluginFile, this.readMode, this.fileOriginProvider.getFileOrigin(idePlugin, pluginFile), null, null, 24, null));
        }
        return CollectionsKt.emptyList();
    }

    public JarPluginLocator(@NotNull Resolver.ReadMode readMode, @NotNull FileOriginProvider fileOriginProvider) {
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(fileOriginProvider, "fileOriginProvider");
        this.readMode = readMode;
        this.fileOriginProvider = fileOriginProvider;
        this.locationKey = JarPluginKey.INSTANCE;
    }

    public /* synthetic */ JarPluginLocator(Resolver.ReadMode readMode, FileOriginProvider fileOriginProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            fileOriginProvider = SingleJarFileOriginProvider.INSTANCE;
        }
        this(readMode, fileOriginProvider);
    }
}

