/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.utils;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.classes.resolvers.InvalidClassFileException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class AsmUtil {
    public static final int ASM_API_LEVEL = 589824;

    @NotNull
    public static ClassNode readClassNode(@NotNull CharSequence className, @NotNull InputStream inputStream2, boolean fully) throws InvalidClassFileException, IOException {
        try {
            ClassNode node = new ClassNode();
            int parsingOptions = fully ? 0 : 7;
            new ClassReader(inputStream2).accept(node, parsingOptions);
            return node;
        }
        catch (ClosedFileSystemException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InvalidClassFileException(className, AsmUtil.getAsmErrorMessage(e));
        }
    }

    @NotNull
    public static ClassNode readClassNode(@NotNull String className, @NotNull InputStream inputStream2) throws InvalidClassFileException, IOException {
        return AsmUtil.readClassNode(className, inputStream2, true);
    }

    private static String getAsmErrorMessage(RuntimeException e) {
        String message2 = e.getLocalizedMessage();
        return e.getClass().getName() + (String)(message2 != null ? ": " + message2 : "");
    }

    @NotNull
    public static String readClassName(@NotNull Path classFile) throws InvalidClassFileException, IOException {
        try (InputStream is = Files.newInputStream(classFile, new OpenOption[0]);){
            String className;
            try {
                className = new ClassReader(is).getClassName();
            }
            catch (RuntimeException e) {
                throw new InvalidClassFileException((CharSequence)FileUtilKt.getNameWithoutExtension(classFile), AsmUtil.getAsmErrorMessage(e));
            }
            if (className == null) {
                throw new InvalidClassFileException((CharSequence)FileUtilKt.getNameWithoutExtension(classFile), "class name is not available in byte-code of " + classFile.toAbsolutePath());
            }
            String string = className;
            return string;
        }
    }

    @NotNull
    public static ClassNode readClassFromFile(@NotNull String className, @NotNull Path classFile, boolean fully) throws IOException, InvalidClassFileException {
        try (InputStream is = Files.newInputStream(classFile, new OpenOption[0]);){
            ClassNode classNode = AsmUtil.readClassNode(className, is, fully);
            return classNode;
        }
    }

    @NotNull
    public static ClassNode readClassFromFile(@NotNull String className, @NotNull Path classFile) throws IOException, InvalidClassFileException {
        return AsmUtil.readClassFromFile(className, classFile, true);
    }
}

