/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.telemetry;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0010\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B3\b\u0016\u0012*\u0010\u0006\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\b0\u0007\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0004H\u0086\u0002J\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003J\b\u0010\u001a\u001a\u00020\u0004H\u0016R\u0018\u0010\n\u001a\u00060\u000bj\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/base/telemetry/PluginTelemetry;", "", "from", "", "", "(Ljava/util/Map;)V", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)V", "archiveFileSize", "", "Lcom/jetbrains/plugin/structure/base/utils/Bytes;", "getArchiveFileSize", "()J", "data", "", "getData", "()Ljava/util/Map;", "parsingDuration", "Ljava/time/Duration;", "getParsingDuration", "()Ljava/time/Duration;", "get", "key", "toMap", "toString", "structure-base"})
public class PluginTelemetry {
    @NotNull
    private final Map<String, Object> data;

    @NotNull
    protected final Map<String, Object> getData() {
        return this.data;
    }

    public long getArchiveFileSize() {
        Object object = this.data.get("plugin.archive.file.size");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.base.utils.Bytes /* = kotlin.Long */");
        }
        return (Long)object;
    }

    @Nullable
    public Duration getParsingDuration() {
        return (Duration)this.data.get("plugin.parsing.duration");
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.data.get(key);
    }

    @NotNull
    public String toString() {
        return this.data.toString();
    }

    @NotNull
    public final Map<String, Object> toMap() {
        return MapsKt.toMap(this.data);
    }

    public PluginTelemetry(@NotNull Map<String, ? extends Object> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        this.data = new LinkedHashMap();
        this.data.putAll(from);
    }

    public PluginTelemetry(Pair<String, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, "pairs");
        this.data = new LinkedHashMap();
        MapsKt.putAll(this.data, pairs);
    }
}

