/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ManyToManyShortestPathsAlgorithm;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BaseManyToManyShortestPaths;
import org.jgrapht.alg.shortestpath.BidirectionalDijkstraShortestPath;

public class DefaultManyToManyShortestPaths<V, E>
extends BaseManyToManyShortestPaths<V, E> {
    private final Function<Graph<V, E>, ShortestPathAlgorithm<V, E>> function;

    public DefaultManyToManyShortestPaths(Graph<V, E> graph) {
        this(graph, g2 -> new BidirectionalDijkstraShortestPath(g2));
    }

    public DefaultManyToManyShortestPaths(Graph<V, E> graph, Function<Graph<V, E>, ShortestPathAlgorithm<V, E>> function) {
        super(graph);
        this.function = function;
    }

    @Override
    public ManyToManyShortestPathsAlgorithm.ManyToManyShortestPaths<V, E> getManyToManyPaths(Set<V> sources, Set<V> targets) {
        Objects.requireNonNull(sources, "sources cannot be null!");
        Objects.requireNonNull(targets, "targets cannot be null!");
        ShortestPathAlgorithm<V, E> algorithm = this.function.apply(this.graph);
        HashMap pathMap = new HashMap();
        for (V source2 : sources) {
            pathMap.put(source2, new HashMap());
        }
        for (V source2 : sources) {
            for (V target : targets) {
                ((Map)pathMap.get(source2)).put(target, algorithm.getPath(source2, target));
            }
        }
        return new DefaultManyToManyShortestPathsImpl(sources, targets, pathMap);
    }

    static class DefaultManyToManyShortestPathsImpl<V, E>
    extends ManyToManyShortestPathsAlgorithm.BaseManyToManyShortestPathsImpl<V, E> {
        private final Map<V, Map<V, GraphPath<V, E>>> pathsMap;

        DefaultManyToManyShortestPathsImpl(Set<V> sources, Set<V> targets, Map<V, Map<V, GraphPath<V, E>>> pathsMap) {
            super(sources, targets);
            this.pathsMap = pathsMap;
        }

        @Override
        public GraphPath<V, E> getPath(V source2, V target) {
            this.assertCorrectSourceAndTarget(source2, target);
            return this.pathsMap.get(source2).get(target);
        }

        @Override
        public double getWeight(V source2, V target) {
            this.assertCorrectSourceAndTarget(source2, target);
            GraphPath<V, E> path = this.pathsMap.get(source2).get(target);
            if (path == null) {
                return Double.POSITIVE_INFINITY;
            }
            return path.getWeight();
        }
    }
}

