/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ManyToManyShortestPathsAlgorithm;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraClosestFirstIterator;
import org.jgrapht.alg.shortestpath.ListSingleSourcePathsImpl;

abstract class BaseManyToManyShortestPaths<V, E>
implements ManyToManyShortestPathsAlgorithm<V, E> {
    protected final Graph<V, E> graph;

    public BaseManyToManyShortestPaths(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph, "Graph is null");
    }

    @Override
    public GraphPath<V, E> getPath(V source2, V sink2) {
        return this.getManyToManyPaths(Collections.singleton(source2), Collections.singleton(sink2)).getPath(source2, sink2);
    }

    @Override
    public double getPathWeight(V source2, V sink2) {
        GraphPath<V, E> p = this.getPath(source2, sink2);
        if (p == null) {
            return Double.POSITIVE_INFINITY;
        }
        return p.getWeight();
    }

    @Override
    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths(V source2) {
        if (!this.graph.containsVertex(source2)) {
            throw new IllegalArgumentException("graph must contain the source vertex");
        }
        HashMap<V, GraphPath<V, E>> paths = new HashMap<V, GraphPath<V, E>>();
        for (V v : this.graph.vertexSet()) {
            paths.put(v, this.getPath(source2, v));
        }
        return new ListSingleSourcePathsImpl<V, E>(this.graph, source2, paths);
    }

    protected static <V, E> ShortestPathAlgorithm.SingleSourcePaths<V, E> getShortestPathsTree(Graph<V, E> graph, V source2, Set<V> targets) {
        DijkstraClosestFirstIterator<V, E> iterator2 = new DijkstraClosestFirstIterator<V, E>(graph, source2);
        int reachedTargets = 0;
        while (iterator2.hasNext() && reachedTargets < targets.size()) {
            if (!targets.contains(iterator2.next())) continue;
            ++reachedTargets;
        }
        return iterator2.getPaths();
    }
}

