/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.instruction;

import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.problems.ChangeFinalFieldProblem;
import com.jetbrains.pluginverifier.results.problems.InstanceAccessOfStaticFieldProblem;
import com.jetbrains.pluginverifier.results.problems.StaticAccessOfInstanceFieldProblem;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import com.jetbrains.pluginverifier.usages.ApiUsageProcessor;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.FieldResolver;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/instruction/FieldAccessInstructionVerifier;", "", "callerMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "fieldOwnerClass", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "fieldReference", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "(Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;Lcom/jetbrains/pluginverifier/results/reference/FieldReference;Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;)V", "processGetField", "", "processGetStatic", "processPutField", "processPutStatic", "resolveField", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "verify", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nFieldAccessInstructionVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldAccessInstructionVerifier.kt\ncom/jetbrains/pluginverifier/verifiers/instruction/FieldAccessInstructionVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1855#2,2:104\n*S KotlinDebug\n*F\n+ 1 FieldAccessInstructionVerifier.kt\ncom/jetbrains/pluginverifier/verifiers/instruction/FieldAccessInstructionVerifier\n*L\n99#1:104,2\n*E\n"})
public final class FieldAccessInstructionVerifier {
    @NotNull
    private final Method callerMethod;
    @NotNull
    private final ClassFile fieldOwnerClass;
    @NotNull
    private final FieldReference fieldReference;
    @NotNull
    private final VerificationContext context;
    @NotNull
    private final Instruction instruction;

    public FieldAccessInstructionVerifier(@NotNull Method callerMethod, @NotNull ClassFile fieldOwnerClass, @NotNull FieldReference fieldReference, @NotNull VerificationContext context, @NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(fieldOwnerClass, "fieldOwnerClass");
        Intrinsics.checkNotNullParameter(fieldReference, "fieldReference");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        this.callerMethod = callerMethod;
        this.fieldOwnerClass = fieldOwnerClass;
        this.fieldReference = fieldReference;
        this.context = context;
        this.instruction = instruction;
    }

    public final void verify() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.instruction.ordinal()]) {
            case 1: {
                this.processPutField();
                break;
            }
            case 2: {
                this.processGetField();
                break;
            }
            case 3: {
                this.processPutStatic();
                break;
            }
            case 4: {
                this.processGetStatic();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private final void processPutField() {
        Field field = this.resolveField();
        if (field == null) {
            return;
        }
        Field field2 = field;
        if (field2.isStatic()) {
            this.context.getProblemRegistrar().registerProblem(new InstanceAccessOfStaticFieldProblem(this.fieldReference, field2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
        if (field2.isFinal() && !Intrinsics.areEqual(field2.getContainingClassFile().getName(), this.callerMethod.getContainingClassFile().getName())) {
            this.context.getProblemRegistrar().registerProblem(new ChangeFinalFieldProblem(this.fieldReference, field2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
    }

    private final void processGetField() {
        Field field = this.resolveField();
        if (field == null) {
            return;
        }
        Field field2 = field;
        if (field2.isStatic()) {
            this.context.getProblemRegistrar().registerProblem(new InstanceAccessOfStaticFieldProblem(this.fieldReference, field2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
    }

    private final void processPutStatic() {
        Field field = this.resolveField();
        if (field == null) {
            return;
        }
        Field field2 = field;
        if (!field2.isStatic()) {
            this.context.getProblemRegistrar().registerProblem(new StaticAccessOfInstanceFieldProblem(this.fieldReference, field2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
        if (field2.isFinal() && !Intrinsics.areEqual(field2.getContainingClassFile().getName(), this.callerMethod.getContainingClassFile().getName())) {
            this.context.getProblemRegistrar().registerProblem(new ChangeFinalFieldProblem(this.fieldReference, field2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
    }

    private final void processGetStatic() {
        Field field = this.resolveField();
        if (field == null) {
            return;
        }
        Field field2 = field;
        if (!field2.isStatic()) {
            this.context.getProblemRegistrar().registerProblem(new StaticAccessOfInstanceFieldProblem(this.fieldReference, field2.getLocation(), this.callerMethod.getLocation(), this.instruction));
        }
    }

    private final Field resolveField() {
        Field field = new FieldResolver().resolveField(this.fieldOwnerClass, this.fieldReference, this.context, this.callerMethod, this.instruction);
        if (field != null) {
            Iterable $this$forEach$iv = this.context.getApiUsageProcessors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApiUsageProcessor it = (ApiUsageProcessor)element$iv;
                boolean bl = false;
                it.processFieldAccess(this.fieldReference, field, this.context, this.callerMethod);
            }
        }
        return field;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Instruction.values().length];
            try {
                nArray[Instruction.PUT_FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.GET_FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.PUT_STATIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.GET_STATIC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

