/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.nonExtendable;

import com.jetbrains.pluginverifier.usages.nonExtendable.NonExtendableApiRegistrar;
import com.jetbrains.pluginverifier.usages.nonExtendable.NonExtendableApiUtilKt;
import com.jetbrains.pluginverifier.usages.nonExtendable.NonExtendableTypeInherited;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.clazz.ClassVerifier;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableTypeInheritedProcessor;", "Lcom/jetbrains/pluginverifier/verifiers/clazz/ClassVerifier;", "nonExtendableApiRegistrar", "Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableApiRegistrar;", "(Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableApiRegistrar;)V", "verify", "", "classFile", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "verifier-intellij"})
public final class NonExtendableTypeInheritedProcessor
implements ClassVerifier {
    @NotNull
    private final NonExtendableApiRegistrar nonExtendableApiRegistrar;

    public NonExtendableTypeInheritedProcessor(@NotNull NonExtendableApiRegistrar nonExtendableApiRegistrar) {
        Intrinsics.checkNotNullParameter(nonExtendableApiRegistrar, "nonExtendableApiRegistrar");
        this.nonExtendableApiRegistrar = nonExtendableApiRegistrar;
    }

    @Override
    public void verify(@NotNull ClassFile classFile, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(classFile, "classFile");
        Intrinsics.checkNotNullParameter(context, "context");
        List<String> superTypeNames = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(classFile.getSuperName()), (Iterable)classFile.getInterfaces());
        for (String superTypeName : superTypeNames) {
            ClassFile superType;
            if (ResolutionUtilKt.resolveClassChecked$default(context.getClassResolver(), superTypeName, classFile, context, null, 8, null) == null || !NonExtendableApiUtilKt.isNonExtendable(superType)) continue;
            this.nonExtendableApiRegistrar.registerNonExtendableApiUsage(new NonExtendableTypeInherited(superType.getLocation(), classFile.getLocation()));
        }
    }
}

