/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.internal.kotlin;

import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.usages.UsageLocationPresentationKt;
import com.jetbrains.pluginverifier.usages.internal.kotlin.KtInternalModifierUsage;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/usages/internal/kotlin/KtInternalClassUsage;", "Lcom/jetbrains/pluginverifier/usages/internal/kotlin/KtInternalModifierUsage;", "apiReference", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "apiElement", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "(Lcom/jetbrains/pluginverifier/results/reference/ClassReference;Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Lcom/jetbrains/pluginverifier/results/location/Location;)V", "getApiElement", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "getApiReference", "()Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUsageLocation", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
public final class KtInternalClassUsage
extends KtInternalModifierUsage {
    @NotNull
    private final ClassReference apiReference;
    @NotNull
    private final ClassLocation apiElement;
    @NotNull
    private final Location usageLocation;

    public KtInternalClassUsage(@NotNull ClassReference apiReference, @NotNull ClassLocation apiElement, @NotNull Location usageLocation) {
        Intrinsics.checkNotNullParameter(apiReference, "apiReference");
        Intrinsics.checkNotNullParameter(apiElement, "apiElement");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        this.apiReference = apiReference;
        this.apiElement = apiElement;
        this.usageLocation = usageLocation;
    }

    @Override
    @NotNull
    public ClassReference getApiReference() {
        return this.apiReference;
    }

    @Override
    @NotNull
    public ClassLocation getApiElement() {
        return this.apiElement;
    }

    @Override
    @NotNull
    public Location getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Usage of class having Kotlin `internal` visibility modifier.";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Internal " + this.getApiElement().getElementType().getPresentableName() + " " + LocationsPresentationKt.formatClassLocation(this.getApiElement(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS) + " reference";
    }

    @Override
    @NotNull
    public String getFullDescription() {
        String element = this.getApiElement().getElementType().getPresentableName();
        return "Internal " + element + " " + LocationsPresentationKt.formatClassLocation(this.getApiElement(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.WITH_GENERICS) + " is referenced in " + UsageLocationPresentationKt.formatUsageLocation(this.getUsageLocation()) + ". This " + element + " is marked with Kotlin `internal` visibility modifier, indicating that it is not supposed to be referenced in client code outside the declaring module.";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof KtInternalModifierUsage && Intrinsics.areEqual(this.getApiReference(), ((KtInternalModifierUsage)other).getApiReference()) && Intrinsics.areEqual(this.getApiElement(), ((KtInternalModifierUsage)other).getApiElement()) && Intrinsics.areEqual(this.getUsageLocation(), ((KtInternalModifierUsage)other).getUsageLocation());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getApiReference(), this.getApiElement(), this.getUsageLocation()};
        return Objects.hash(objectArray);
    }
}

