/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.signatures;

import com.jetbrains.pluginverifier.results.signatures.ClassTypeSignature;
import com.jetbrains.pluginverifier.results.signatures.FormatOptions;
import com.jetbrains.pluginverifier.results.signatures.FormattableSignature;
import com.jetbrains.pluginverifier.results.signatures.ReferenceTypeSignature;
import com.jetbrains.pluginverifier.results.signatures.SignatureKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/pluginverifier/results/signatures/TypeParameter;", "Lcom/jetbrains/pluginverifier/results/signatures/FormattableSignature;", "identifier", "", "Lcom/jetbrains/pluginverifier/results/signatures/Identifier;", "classBound", "Lcom/jetbrains/pluginverifier/results/signatures/ReferenceTypeSignature;", "interfaceBounds", "", "(Ljava/lang/String;Lcom/jetbrains/pluginverifier/results/signatures/ReferenceTypeSignature;Ljava/util/List;)V", "getClassBound", "()Lcom/jetbrains/pluginverifier/results/signatures/ReferenceTypeSignature;", "getIdentifier", "()Ljava/lang/String;", "getInterfaceBounds", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "format", "formatOptions", "Lcom/jetbrains/pluginverifier/results/signatures/FormatOptions;", "hashCode", "", "toString", "verifier-core"})
public final class TypeParameter
implements FormattableSignature {
    @NotNull
    private final String identifier;
    @Nullable
    private final ReferenceTypeSignature classBound;
    @NotNull
    private final List<ReferenceTypeSignature> interfaceBounds;

    public TypeParameter(@NotNull String identifier, @Nullable ReferenceTypeSignature classBound, @NotNull List<? extends ReferenceTypeSignature> interfaceBounds) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(interfaceBounds, "interfaceBounds");
        this.identifier = identifier;
        this.classBound = classBound;
        this.interfaceBounds = interfaceBounds;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public final ReferenceTypeSignature getClassBound() {
        return this.classBound;
    }

    @NotNull
    public final List<ReferenceTypeSignature> getInterfaceBounds() {
        return this.interfaceBounds;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append(this.identifier);
        $this$toString_u24lambda_u240.append(":").append(SignatureKt.toStringOrEmpty(this.classBound));
        for (ReferenceTypeSignature interfaceBound : this.interfaceBounds) {
            $this$toString_u24lambda_u240.append(":").append(interfaceBound);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String format(@NotNull FormatOptions formatOptions) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(formatOptions, "formatOptions");
        StringBuilder $this$format_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$format_u24lambda_u241.append(this.identifier);
        if (formatOptions.getFormalTypeParametersBounds()) {
            boolean needSuper;
            boolean bl2 = needSuper = this.classBound != null && (!(this.classBound instanceof ClassTypeSignature) || !Intrinsics.areEqual(((ClassTypeSignature)this.classBound).getTopClassTypeSignature().getIdentifier(), "java/lang/Object"));
            if (needSuper) {
                StringBuilder stringBuilder2 = $this$format_u24lambda_u241.append(" extends ");
                ReferenceTypeSignature referenceTypeSignature = this.classBound;
                Intrinsics.checkNotNull(referenceTypeSignature);
                stringBuilder2.append(referenceTypeSignature.format(formatOptions));
            }
            if (!((Collection)this.interfaceBounds).isEmpty()) {
                if (needSuper) {
                    $this$format_u24lambda_u241.append(", ");
                } else {
                    $this$format_u24lambda_u241.append(" extends ");
                }
                $this$format_u24lambda_u241.append(CollectionsKt.joinToString$default(this.interfaceBounds, null, null, null, 0, null, new Function1<ReferenceTypeSignature, CharSequence>(formatOptions){
                    final /* synthetic */ FormatOptions $formatOptions;
                    {
                        this.$formatOptions = $formatOptions;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull ReferenceTypeSignature it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it.format(this.$formatOptions);
                    }
                }, 31, null));
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.identifier;
    }

    @Nullable
    public final ReferenceTypeSignature component2() {
        return this.classBound;
    }

    @NotNull
    public final List<ReferenceTypeSignature> component3() {
        return this.interfaceBounds;
    }

    @NotNull
    public final TypeParameter copy(@NotNull String identifier, @Nullable ReferenceTypeSignature classBound, @NotNull List<? extends ReferenceTypeSignature> interfaceBounds) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(interfaceBounds, "interfaceBounds");
        return new TypeParameter(identifier, classBound, interfaceBounds);
    }

    public static /* synthetic */ TypeParameter copy$default(TypeParameter typeParameter, String string, ReferenceTypeSignature referenceTypeSignature, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = typeParameter.identifier;
        }
        if ((n & 2) != 0) {
            referenceTypeSignature = typeParameter.classBound;
        }
        if ((n & 4) != 0) {
            list = typeParameter.interfaceBounds;
        }
        return typeParameter.copy(string, referenceTypeSignature, list);
    }

    public int hashCode() {
        int result2 = this.identifier.hashCode();
        result2 = result2 * 31 + (this.classBound == null ? 0 : this.classBound.hashCode());
        result2 = result2 * 31 + ((Object)this.interfaceBounds).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeParameter)) {
            return false;
        }
        TypeParameter typeParameter = (TypeParameter)other;
        if (!Intrinsics.areEqual(this.identifier, typeParameter.identifier)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.classBound, typeParameter.classBound)) {
            return false;
        }
        return Intrinsics.areEqual(this.interfaceBounds, typeParameter.interfaceBounds);
    }
}

