/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.FieldLocation;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/StaticAccessOfInstanceFieldProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "fieldReference", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "field", "Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "accessor", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "(Lcom/jetbrains/pluginverifier/results/reference/FieldReference;Lcom/jetbrains/pluginverifier/results/location/FieldLocation;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;)V", "getAccessor", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "getField", "()Lcom/jetbrains/pluginverifier/results/location/FieldLocation;", "getFieldReference", "()Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getInstruction", "()Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class StaticAccessOfInstanceFieldProblem
extends CompatibilityProblem {
    @NotNull
    private final FieldReference fieldReference;
    @NotNull
    private final FieldLocation field;
    @NotNull
    private final MethodLocation accessor;
    @NotNull
    private final Instruction instruction;

    public StaticAccessOfInstanceFieldProblem(@NotNull FieldReference fieldReference, @NotNull FieldLocation field, @NotNull MethodLocation accessor, @NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(fieldReference, "fieldReference");
        Intrinsics.checkNotNullParameter(field, "field");
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        this.fieldReference = fieldReference;
        this.field = field;
        this.accessor = accessor;
        this.instruction = instruction;
    }

    @NotNull
    public final FieldReference getFieldReference() {
        return this.fieldReference;
    }

    @NotNull
    public final FieldLocation getField() {
        return this.field;
    }

    @NotNull
    public final MethodLocation getAccessor() {
        return this.accessor;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Static field changed to instance field";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.instruction, this.field};
        return FormatUtilsKt.formatMessage("Attempt to execute static access instruction *{0}* on instance field {1}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{this.accessor, this.instruction, this.field};
        return FormatUtilsKt.formatMessage("Method {0} has static field access instruction *{1}* referencing an instance field {2}, what might have been caused by incompatible change of the field from static to instance. This can lead to **IncompatibleClassChangeError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof StaticAccessOfInstanceFieldProblem && Intrinsics.areEqual(this.fieldReference, ((StaticAccessOfInstanceFieldProblem)other).fieldReference) && Intrinsics.areEqual(this.field, ((StaticAccessOfInstanceFieldProblem)other).field) && Intrinsics.areEqual(this.accessor, ((StaticAccessOfInstanceFieldProblem)other).accessor) && this.instruction == ((StaticAccessOfInstanceFieldProblem)other).instruction;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.fieldReference, this.field, this.accessor, this.instruction};
        return Objects.hash(objectArray);
    }
}

