/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/MultipleDefaultImplementationsProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "caller", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "implementation1", "implementation2", "(Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/reference/MethodReference;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;)V", "getCaller", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getImplementation1", "getImplementation2", "getInstruction", "()Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "getMethodReference", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class MultipleDefaultImplementationsProblem
extends CompatibilityProblem {
    @NotNull
    private final MethodLocation caller;
    @NotNull
    private final MethodReference methodReference;
    @NotNull
    private final Instruction instruction;
    @NotNull
    private final MethodLocation implementation1;
    @NotNull
    private final MethodLocation implementation2;

    public MultipleDefaultImplementationsProblem(@NotNull MethodLocation caller2, @NotNull MethodReference methodReference, @NotNull Instruction instruction, @NotNull MethodLocation implementation1, @NotNull MethodLocation implementation2) {
        Intrinsics.checkNotNullParameter(caller2, "caller");
        Intrinsics.checkNotNullParameter(methodReference, "methodReference");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        Intrinsics.checkNotNullParameter(implementation1, "implementation1");
        Intrinsics.checkNotNullParameter(implementation2, "implementation2");
        this.caller = caller2;
        this.methodReference = methodReference;
        this.instruction = instruction;
        this.implementation1 = implementation1;
        this.implementation2 = implementation2;
    }

    @NotNull
    public final MethodLocation getCaller() {
        return this.caller;
    }

    @NotNull
    public final MethodReference getMethodReference() {
        return this.methodReference;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @NotNull
    public final MethodLocation getImplementation1() {
        return this.implementation1;
    }

    @NotNull
    public final MethodLocation getImplementation2() {
        return this.implementation2;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Multiple default implementations";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.methodReference};
        return FormatUtilsKt.formatMessage("Multiple default implementations of method {0}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{this.caller, this.instruction, this.methodReference, this.implementation1, this.implementation2};
        return FormatUtilsKt.formatMessage("Method {0} contains an *{1}* instruction referencing a method reference {2} which has multiple default implementations: {3} and {4}. This can lead to **IncompatibleClassChangeError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof MultipleDefaultImplementationsProblem && Intrinsics.areEqual(this.caller, ((MultipleDefaultImplementationsProblem)other).caller) && this.instruction == ((MultipleDefaultImplementationsProblem)other).instruction && Intrinsics.areEqual(this.methodReference, ((MultipleDefaultImplementationsProblem)other).methodReference) && Intrinsics.areEqual(this.implementation1, ((MultipleDefaultImplementationsProblem)other).implementation1) && Intrinsics.areEqual(this.implementation2, ((MultipleDefaultImplementationsProblem)other).implementation2);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.caller, this.instruction, this.methodReference, this.implementation1, this.implementation2};
        return Objects.hash(objectArray);
    }
}

