/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/InvokeInterfaceMethodOnClassProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "caller", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "(Lcom/jetbrains/pluginverifier/results/reference/MethodReference;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;)V", "getCaller", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "changedInterface", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "getChangedInterface", "()Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getInstruction", "()Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "getMethodReference", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class InvokeInterfaceMethodOnClassProblem
extends CompatibilityProblem {
    @NotNull
    private final MethodReference methodReference;
    @NotNull
    private final MethodLocation caller;
    @NotNull
    private final Instruction instruction;

    public InvokeInterfaceMethodOnClassProblem(@NotNull MethodReference methodReference, @NotNull MethodLocation caller2, @NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(methodReference, "methodReference");
        Intrinsics.checkNotNullParameter(caller2, "caller");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        this.methodReference = methodReference;
        this.caller = caller2;
        this.instruction = instruction;
    }

    @NotNull
    public final MethodReference getMethodReference() {
        return this.methodReference;
    }

    @NotNull
    public final MethodLocation getCaller() {
        return this.caller;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Incompatible change of interface to class";
    }

    @NotNull
    public final ClassReference getChangedInterface() {
        return this.methodReference.getHostClass();
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.getChangedInterface()};
        return FormatUtilsKt.formatMessage("Incompatible change of interface {0} to class", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{this.caller, this.instruction, this.methodReference, this.methodReference.getHostClass()};
        return FormatUtilsKt.formatMessage("Method {0} has invocation *{1}* instruction referencing an *interface* method {2}, but the method''s host {3} is a *class*. This can lead to **IncompatibleClassChangeError** at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof InvokeInterfaceMethodOnClassProblem && Intrinsics.areEqual(this.methodReference, ((InvokeInterfaceMethodOnClassProblem)other).methodReference) && Intrinsics.areEqual(this.caller, ((InvokeInterfaceMethodOnClassProblem)other).caller) && this.instruction == ((InvokeInterfaceMethodOnClassProblem)other).instruction;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.methodReference, this.caller, this.instruction};
        return Objects.hash(objectArray);
    }
}

