/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.location;

import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.pluginverifier.results.location.ElementType;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.modifiers.Modifiers;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J3\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u0014\u0010\u0019\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006'"}, d2={"Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "Lcom/jetbrains/pluginverifier/results/location/Location;", "className", "", "signature", "modifiers", "Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;", "classFileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;)V", "getClassFileOrigin", "()Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "getClassName", "()Ljava/lang/String;", "containingClass", "getContainingClass", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "elementType", "Lcom/jetbrains/pluginverifier/results/location/ElementType;", "getElementType", "()Lcom/jetbrains/pluginverifier/results/location/ElementType;", "getModifiers", "()Lcom/jetbrains/pluginverifier/results/modifiers/Modifiers;", "packageName", "getPackageName", "presentableLocation", "getPresentableLocation", "getSignature", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class ClassLocation
extends Location {
    @NotNull
    private final String className;
    @Nullable
    private final String signature;
    @NotNull
    private final Modifiers modifiers;
    @NotNull
    private final FileOrigin classFileOrigin;

    public ClassLocation(@NotNull String className, @Nullable String signature2, @NotNull Modifiers modifiers, @NotNull FileOrigin classFileOrigin) {
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        Intrinsics.checkNotNullParameter(classFileOrigin, "classFileOrigin");
        super(null);
        this.className = className;
        this.signature = signature2;
        this.modifiers = modifiers;
        this.classFileOrigin = classFileOrigin;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @Nullable
    public final String getSignature() {
        return this.signature;
    }

    @NotNull
    public final Modifiers getModifiers() {
        return this.modifiers;
    }

    @NotNull
    public final FileOrigin getClassFileOrigin() {
        return this.classFileOrigin;
    }

    @NotNull
    public final String getPackageName() {
        return StringsKt.substringBeforeLast(this.className, '/', "");
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ClassLocation && Intrinsics.areEqual(this.className, ((ClassLocation)other).className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    @NotNull
    public String getPresentableLocation() {
        return LocationsPresentationKt.formatClassLocation(this, ClassOption.FULL_NAME, ClassGenericsSignatureOption.WITH_GENERICS);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        Modifiers $this$_get_elementType__u24lambda_u240 = this.modifiers;
        boolean bl = false;
        return $this$_get_elementType__u24lambda_u240.contains(Modifiers.Modifier.INTERFACE) ? ElementType.INTERFACE : ($this$_get_elementType__u24lambda_u240.contains(Modifiers.Modifier.ENUM) ? ElementType.ENUM : ($this$_get_elementType__u24lambda_u240.contains(Modifiers.Modifier.ANNOTATION) ? ElementType.ANNOTATION : ElementType.CLASS));
    }

    @Override
    @NotNull
    public ClassLocation getContainingClass() {
        return this;
    }

    @NotNull
    public final String component1() {
        return this.className;
    }

    @Nullable
    public final String component2() {
        return this.signature;
    }

    @NotNull
    public final Modifiers component3() {
        return this.modifiers;
    }

    @NotNull
    public final FileOrigin component4() {
        return this.classFileOrigin;
    }

    @NotNull
    public final ClassLocation copy(@NotNull String className, @Nullable String signature2, @NotNull Modifiers modifiers, @NotNull FileOrigin classFileOrigin) {
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        Intrinsics.checkNotNullParameter(classFileOrigin, "classFileOrigin");
        return new ClassLocation(className, signature2, modifiers, classFileOrigin);
    }

    public static /* synthetic */ ClassLocation copy$default(ClassLocation classLocation, String string, String string2, Modifiers modifiers, FileOrigin fileOrigin, int n, Object object) {
        if ((n & 1) != 0) {
            string = classLocation.className;
        }
        if ((n & 2) != 0) {
            string2 = classLocation.signature;
        }
        if ((n & 4) != 0) {
            modifiers = classLocation.modifiers;
        }
        if ((n & 8) != 0) {
            fileOrigin = classLocation.classFileOrigin;
        }
        return classLocation.copy(string, string2, modifiers, fileOrigin);
    }
}

